/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4processors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.opencypher.tools.antlr.bnf.BNFBaseListener;
import org.opencypher.tools.antlr.bnf.BNFParser;
import org.opencypher.tools.g4tree.BnfSymbolLiteral;
import org.opencypher.tools.g4tree.BnfSymbols;
import org.opencypher.tools.g4tree.CharacterLiteral;
import org.opencypher.tools.g4tree.EOFreference;
import org.opencypher.tools.g4tree.ElementWithCardinality;
import org.opencypher.tools.g4tree.ExclusionCharacterSet;
import org.opencypher.tools.g4tree.FreeTextItem;
import org.opencypher.tools.g4tree.GrammarItem;
import org.opencypher.tools.g4tree.GrammarName;
import org.opencypher.tools.g4tree.GrammarTop;
import org.opencypher.tools.g4tree.Group;
import org.opencypher.tools.g4tree.InAlternative;
import org.opencypher.tools.g4tree.InAlternatives;
import org.opencypher.tools.g4tree.InLiteral;
import org.opencypher.tools.g4tree.InOptional;
import org.opencypher.tools.g4tree.ListedCharacterSet;
import org.opencypher.tools.g4tree.NamedCharacterSet;
import org.opencypher.tools.g4tree.OneOrMore;
import org.opencypher.tools.g4tree.Rule;
import org.opencypher.tools.g4tree.RuleId;
import org.opencypher.tools.g4tree.RuleList;
import org.opencypher.tools.g4tree.ZeroOrMore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BNFListener
extends BNFBaseListener {
    private final ParseTreeProperty<GrammarItem> items = new ParseTreeProperty();
    private final CommonTokenStream tokens;
    private GrammarTop treeTop = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNFListener.class.getName());
    private static final Pattern UCODE_PATTERN = Pattern.compile("\\\\u([0-9a-fA-F]+)");

    public BNFListener(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    public GrammarTop getTreeTop() {
        return this.treeTop;
    }

    private GrammarItem getItem(ParseTree ctx) {
        return (GrammarItem)this.items.get(ctx);
    }

    private void setItem(ParseTree ctx, GrammarItem item) {
        LOGGER.debug("setting a {} for {}", (Object)item.getClass().getSimpleName(), (Object)ctx.getText());
        this.items.put(ctx, (Object)item);
    }

    private void pullUpItem(ParseTree ctx) {
        if (ctx.getChildCount() != 1) {
            throw new IllegalStateException("There should be only one child at " + ctx.getText() + " but there are " + ctx.getChildCount());
        }
        GrammarItem movedItem = this.getItem(ctx.getChild(0));
        if (movedItem == null) {
            throw new IllegalStateException("No item to be moved from " + ctx.getChild(0).getClass().getSimpleName() + " up to " + ctx.getClass().getSimpleName());
        }
        this.items.put(ctx, (Object)movedItem);
    }

    @Override
    public void exitRulelist(BNFParser.RulelistContext ctx) {
        String header = this.findHiddenTextBefore(ctx, true).replaceFirst("\r?\n$", "");
        RuleList rules = new RuleList();
        GrammarName name = null;
        for (BNFParser.Rule_Context ruleCtx : ctx.rule_()) {
            GrammarItem grammarItem = this.getItem((ParseTree)ruleCtx);
            if (name == null) {
                name = new GrammarName(((Rule)grammarItem).getRuleName());
            }
            rules.addItem(grammarItem);
        }
        this.treeTop = new GrammarTop(name, rules, header.length() > 0 ? header : null);
    }

    @Override
    public void exitRule_(BNFParser.Rule_Context ctx) {
        String description = (this.findHiddenTextBefore(ctx, false) + this.findHiddenTextWithin(ctx) + this.findHiddenTextAfter(ctx)).replaceFirst("\r?\n$", "");
        Rule rule = new Rule(this.getItem((ParseTree)ctx.lhs()), this.getItem((ParseTree)ctx.rhs()), description.length() == 0 ? null : description);
        this.setItem((ParseTree)ctx, rule);
    }

    @Override
    public void exitLhs(BNFParser.LhsContext ctx) {
        this.setItem((ParseTree)ctx, this.getItem(ctx.getChild(1)));
    }

    @Override
    public void exitBnfsymbols(BNFParser.BnfsymbolsContext ctx) {
        this.setItem((ParseTree)ctx, new InLiteral(ctx.getText()));
    }

    @Override
    public void exitRhs(BNFParser.RhsContext ctx) {
        this.pullUpItem((ParseTree)ctx);
    }

    @Override
    public void exitAlternatives(BNFParser.AlternativesContext ctx) {
        InAlternatives alts = new InAlternatives();
        for (BNFParser.AlternativeContext element : ctx.alternative()) {
            alts.addItem(this.getItem((ParseTree)element));
        }
        this.setItem((ParseTree)ctx, alts);
    }

    @Override
    public void exitAlternative(BNFParser.AlternativeContext ctx) {
        InAlternative alt = new InAlternative();
        for (BNFParser.ElementContext element : ctx.element()) {
            alt.addItem(this.getItem((ParseTree)element));
        }
        if (alt.size() == 2 && alt.getChildren().stream().allMatch(c -> c.getType() == GrammarItem.ItemType.LITERAL && ((InLiteral)c).getValue().equals("/"))) {
            alt = new InAlternative();
            alt.addItem(new InLiteral("//"));
        }
        this.setItem((ParseTree)ctx, alt);
    }

    private String findHiddenTextBefore(ParserRuleContext ctx, boolean forHeader) {
        Token startCtx = ctx.getStart();
        int i = startCtx.getTokenIndex();
        List normalTextChannel = this.tokens.getHiddenTokensToLeft(i, 1);
        if (normalTextChannel != null) {
            List lineTokens = normalTextChannel.stream().collect(Collectors.toList());
            int precedingBlankLines = startCtx.getLine() - ((Token)lineTokens.get(lineTokens.size() - 1)).getLine() - 1;
            if (precedingBlankLines > 0) {
                if (forHeader) {
                    return lineTokens.stream().map(tk -> tk.getText().replaceFirst("// ?", "")).collect(Collectors.joining("\n"));
                }
            } else {
                if (forHeader) {
                    return "";
                }
                int lastGoodLine = startCtx.getLine() - 1;
                for (int currentIndex = lineTokens.size() - 1; currentIndex >= 0 && ((Token)lineTokens.get(currentIndex)).getLine() == lastGoodLine; --currentIndex, --lastGoodLine) {
                }
                ArrayList<String> content = new ArrayList<String>();
                for (int j = currentIndex + 1; j < lineTokens.size(); ++j) {
                    content.add(((Token)lineTokens.get(j)).getText().replaceFirst("// ?", ""));
                }
                return content.stream().collect(Collectors.joining("\n"));
            }
        }
        return "";
    }

    private String findHiddenTextWithin(ParserRuleContext ctx) {
        List allTokens = this.tokens.get(ctx.getStart().getTokenIndex(), ctx.getStop().getTokenIndex());
        return allTokens.stream().filter(t -> t.getChannel() == 1).map(t -> t.getText().replaceFirst("// ?", "")).collect(Collectors.joining("\n"));
    }

    private String findHiddenTextAfter(ParserRuleContext ctx) {
        Token endCtx = ctx.getStop();
        int i = endCtx.getTokenIndex();
        List normalTextChannel = this.tokens.getHiddenTokensToRight(i, 1);
        if (normalTextChannel != null) {
            Token lineToken;
            ArrayList<String> content = new ArrayList<String>();
            Iterator iterator = normalTextChannel.iterator();
            for (int nextLine = endCtx.getLine() + 1; iterator.hasNext() && (lineToken = (Token)iterator.next()).getLine() == nextLine; ++nextLine) {
                content.add(lineToken.getText().replaceFirst("// ?", ""));
            }
            return content.stream().collect(Collectors.joining("\n"));
        }
        return "";
    }

    @Override
    public void exitElement(BNFParser.ElementContext ctx) {
        this.pullUpItem((ParseTree)ctx);
    }

    @Override
    public void exitOptionalitem(BNFParser.OptionalitemContext ctx) {
        GrammarItem simplifiedContent;
        GrammarItem contentItem = this.getItem((ParseTree)ctx.alternatives());
        ElementWithCardinality ourItem = ctx.ELLIPSIS() == null ? ((simplifiedContent = contentItem.reachThrough()) instanceof OneOrMore ? new ZeroOrMore(((OneOrMore)simplifiedContent).getContent()) : new InOptional(contentItem)) : new ZeroOrMore(contentItem);
        this.setItem((ParseTree)ctx, ourItem);
    }

    @Override
    public void exitRequireditem(BNFParser.RequireditemContext ctx) {
        GrammarItem contentItem = this.getItem((ParseTree)ctx.alternatives());
        GrammarItem ourItem = ctx.ELLIPSIS() == null ? (contentItem.isPlural() ? new Group(contentItem) : contentItem) : new OneOrMore(contentItem);
        this.setItem((ParseTree)ctx, ourItem);
    }

    @Override
    public void exitText(BNFParser.TextContext ctx) {
        String text = ctx.getText().trim();
        if (ctx.UNICODE_LITERAL() != null) {
            this.setItem((ParseTree)ctx, new InLiteral(Character.valueOf((char)Integer.parseInt(text.substring(2), 16)).toString()));
        } else if (ctx.CHARACTER_LITERAL() != null) {
            this.setItem((ParseTree)ctx, new CharacterLiteral(text));
        } else {
            this.setItem((ParseTree)ctx, new InLiteral(text));
        }
    }

    @Override
    public void exitCharacterset(BNFParser.CharactersetContext ctx) {
        GrammarItem movedItem;
        if (ctx.getChildCount() == 3) {
            movedItem = this.getItem(ctx.getChild(1));
            if (movedItem == null) {
                throw new IllegalStateException("No item to be moved from " + ctx.getChild(1).getClass().getSimpleName() + " up to " + ((Object)((Object)ctx)).getClass().getSimpleName());
            }
        } else {
            throw new IllegalStateException("child count for character set is " + ctx.getChildCount() + ". expected 3");
        }
        this.items.put((ParseTree)ctx, (Object)movedItem);
    }

    @Override
    public void exitNamedcharacterset(BNFParser.NamedcharactersetContext ctx) {
        this.setItem((ParseTree)ctx, new NamedCharacterSet(ctx.ID().getText()));
    }

    @Override
    public void exitExclusioncharacterset(BNFParser.ExclusioncharactersetContext ctx) {
        BNFParser.ListcharactersetContext listCtx = ctx.listcharacterset();
        this.setItem((ParseTree)ctx, new ExclusionCharacterSet(this.interpret(listCtx)));
    }

    @Override
    public void exitListcharacterset(BNFParser.ListcharactersetContext ctx) {
        this.setItem((ParseTree)ctx, new ListedCharacterSet(this.interpret(ctx)));
    }

    @Override
    public void exitNormaltext(BNFParser.NormaltextContext ctx) {
        String content = ctx.getText().replaceFirst("!!\\s*", "");
        if (content.matches("\\s*")) {
            return;
        }
        this.setItem((ParseTree)ctx, new FreeTextItem(content));
    }

    private String interpret(BNFParser.ListcharactersetContext listCtx) {
        List bnfString = listCtx.text().stream().map(RuleContext::getText).collect(Collectors.toList());
        LOGGER.debug("bnfString {}.", bnfString);
        StringBuilder b = new StringBuilder();
        while (!bnfString.isEmpty()) {
            String piece = (String)bnfString.remove(0);
            LOGGER.debug("piece is [{}]", (Object)piece);
            if (!piece.equals("\\")) {
                b.append(piece);
                continue;
            }
            String next = (String)bnfString.remove(0);
            char first = next.charAt(0);
            String rest = next.substring(1);
            switch (first) {
                case 'r': {
                    b.append('\r');
                    break;
                }
                case 'n': {
                    b.append("\n");
                    break;
                }
                case 't': {
                    b.append("\t");
                    break;
                }
                case 'b': {
                    b.append("\b");
                    break;
                }
                case 'f': {
                    b.append("\f");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '-': {
                    b.append("-");
                    break;
                }
                case ']': {
                    b.append("]");
                    break;
                }
                case '$': {
                    b.append("$");
                    break;
                }
                case '/': {
                    b.append("/");
                    break;
                }
                case 'u': {
                    if (rest.length() < 4) {
                        throw new IllegalArgumentException("unicode escape requires 4 hex digits");
                    }
                    int cp = Integer.parseInt(rest.substring(1, 4), 16);
                    b.append((char)cp);
                    rest = rest.substring(4);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know how to interpret escaped character " + first);
                }
            }
            if (rest.length() <= 0) continue;
            b.append(rest);
        }
        String answer = b.toString();
        return answer;
    }

    @Override
    public void exitId(BNFParser.IdContext ctx) {
        String ruleName = ctx.ruleref().getText();
        if (ruleName.equals(EOFreference.BNF_NAME)) {
            this.setItem((ParseTree)ctx, new EOFreference());
        } else {
            RuleId item = new RuleId(ruleName);
            if (ctx.ELLIPSIS() != null) {
                this.setItem((ParseTree)ctx, new OneOrMore(item));
            } else {
                this.setItem((ParseTree)ctx, item);
            }
        }
    }

    @Override
    public void exitRuleref(BNFParser.RulerefContext ctx) {
        String referencedName = ctx.getText();
        BnfSymbols bnfSymbol = BnfSymbols.getByName(referencedName);
        if (bnfSymbol != null) {
            this.setItem((ParseTree)ctx, new BnfSymbolLiteral(bnfSymbol));
        } else {
            this.setItem((ParseTree)ctx, new RuleId(referencedName));
        }
    }

    @Override
    public void exitRuleid(BNFParser.RuleidContext ctx) {
        this.setItem((ParseTree)ctx, new RuleId(ctx.getText()));
    }
}

