/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.grammar.Grammar;
import org.opencypher.tools.Reflection;
import org.opencypher.tools.grammar.Antlr4;
import org.opencypher.tools.grammar.ISO14977;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.grammar.ParseTrees;
import org.opencypher.tools.grammar.RailRoadDiagramPages;
import org.opencypher.tools.grammar.SQLBNF;
import org.opencypher.tools.io.Output;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.Child;
import org.opencypher.tools.xml.Element;
import org.opencypher.tools.xml.XmlFile;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.SAXException;

@Element(uri="http://opencypher.org/grammar/project", name="project")
class Project {
    static final String NAMESPACE = "http://opencypher.org/grammar/project";
    static final XmlParser<Project> XML = XmlParser.xmlParser(Project.class);
    private final List<Source> sources = new ArrayList<Source>();
    private final List<Target> targets = new ArrayList<Target>();

    Project() {
    }

    public static void main(String ... args) throws Exception {
        if (args == null || args.length < 1) {
            String path = Reflection.pathOf(Main.class);
            if (new File(path).isFile() && path.endsWith(".jar")) {
                System.err.printf("USAGE: java -jar %s Project <project.xml> ...%n", path);
            } else {
                System.err.printf("USAGE: java -cp %s %s Project <project.xml> ...%n", path, Main.class.getName());
            }
            System.exit(1);
        } else {
            Path xml = Path.of(args[0], new String[0]);
            if (!Files.isRegularFile(xml, new LinkOption[0])) {
                System.err.println("No such file: " + args[0]);
                System.exit(1);
            }
            HashMap<String, String> options = new HashMap<String, String>();
            for (int i = 1; i < args.length; ++i) {
                int eq = args[i].indexOf(61);
                if (eq < 0) {
                    options.put(args[i], null);
                    continue;
                }
                options.put(args[i].substring(0, eq), args[i].substring(eq + 1));
            }
            XML.parse(xml, new XmlParser.Option[0]).execute(xml.getParent(), options);
        }
    }

    @Child
    void input(Source input) {
        this.sources.add(input);
    }

    @Child
    void output(Target output) {
        this.targets.add(output);
    }

    void execute(Path workingDir, Map<String, String> options) throws Exception {
        for (Task task : this.work(this.grammars())) {
            task.execute(workingDir);
        }
    }

    private Map<String, Grammar> grammars() throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, Grammar.Unresolved> resolution = new HashMap<String, Grammar.Unresolved>();
        Grammar.Unresolved[] prestage = new Grammar.Unresolved[this.sources.size()];
        for (int i = 0; i < prestage.length; ++i) {
            Source source = this.sources.get(i);
            prestage[i] = Grammar.Unresolved.parseXML(source.path);
            resolution.put(source.id, prestage[i]);
        }
        HashMap<String, Grammar> grammars = new HashMap<String, Grammar>();
        for (int i = 0; i < prestage.length; ++i) {
            Source source = this.sources.get(i);
            grammars.put(source.id, prestage[i].resolve(source.resolver(resolution)));
        }
        return grammars;
    }

    private Task[] work(Map<String, Grammar> grammars) {
        Task[] work = new Task[this.targets.size()];
        HashMap<String, Map<Tool, List<Task>>> tasks = new HashMap<String, Map<Tool, List<Task>>>();
        for (int i = 0; i < work.length; ++i) {
            Target target = this.targets.get(i);
            Grammar grammar = grammars.get(target.grammar);
            if (grammar == null) {
                throw new IllegalArgumentException("No such grammar: " + target.grammar);
            }
            work[i] = new Task(grammar, target.tool, target.path, target.options, tasks);
            tasks.computeIfAbsent(target.grammar, key -> new EnumMap(Tool.class)).computeIfAbsent(target.tool, key -> new ArrayList()).add(work[i]);
        }
        return work;
    }

    private static class Task {
        private final Grammar grammar;
        private final Tool tool;
        private final Path path;
        private final Map<String, Object> options = new HashMap<String, Object>();
        private final Map<String, Map<Tool, List<Task>>> tasks;

        Task(Grammar grammar, Tool tool, Path path, Map<String, Object> options, Map<String, Map<Tool, List<Task>>> tasks) {
            this.grammar = grammar;
            this.tool = tool;
            this.path = path;
            this.tasks = tasks;
            for (Map.Entry<String, Object> option : options.entrySet()) {
                this.options.put(tool.reKey(option.getKey()), option.getValue());
            }
        }

        void execute(Path workingDir) {
            try {
                this.tool.execute(this.grammar, workingDir, this.path, this.options);
            }
            catch (Exception e) {
                System.err.printf("Failed to execute %s on %s.%n", this.tool.name(), this.grammar.language());
                e.printStackTrace();
            }
        }
    }

    static enum Tool {
        RAIL_ROAD_DIAGRAM_PAGES((Class)RailRoadDiagramPages.class){

            @Override
            void execute(Grammar grammar, Path workingDir, Path path, Map<String, Object> options) throws Exception {
                options.put(this.reKey("outputDir"), path);
                RailRoadDiagramPages.generate(grammar, workingDir, this.log(options), options);
            }
        }
        ,
        WG3BNF((Class)SQLBNF.class){

            @Override
            void execute(Grammar grammar, Path workingDir, Path path, Map<String, Object> options) throws Exception {
                this.write(grammar, workingDir, SQLBNF::write, path);
            }
        }
        ,
        ISO14977((Class)ISO14977.class){

            @Override
            void execute(Grammar grammar, Path workingDir, Path path, Map<String, Object> options) throws Exception {
                this.write(grammar, workingDir, ISO14977::write, path);
            }
        }
        ,
        ANTLR4((Class)Antlr4.class){

            @Override
            void execute(Grammar grammar, Path workingDir, Path path, Map<String, Object> options) throws Exception {
                this.write(grammar, workingDir, Antlr4::write, path);
            }
        }
        ,
        PARSE_TREES((Class)ParseTrees.class){

            @Override
            void execute(Grammar grammar, Path workingDir, Path path, Map<String, Object> options) throws Exception {
                options.put(this.reKey("outputDir"), path);
                new ParseTrees(workingDir, options).generate(grammar, this.log(options));
            }
        };

        private final String keyPrefix;

        private Tool(Class<?> tool) {
            this.keyPrefix = tool.getSimpleName();
        }

        void addOption(Map<String, Object> options, String key, String value) {
            options.put(key, value);
        }

        abstract void execute(Grammar var1, Path var2, Path var3, Map<String, Object> var4) throws Exception;

        String reKey(String key) {
            return this.keyPrefix + "." + key;
        }

        Path path(Map<String, Object> options, String key) {
            Object path = options.get(this.reKey(key));
            if (path instanceof String) {
                path = Path.of((String)path, new String[0]);
            }
            return (Path)path;
        }

        Output log(Map<String, Object> options) {
            Object log = options.get(this.reKey("log"));
            if (log instanceof String) {
                log = Output.output(Path.of((String)log, new String[0]));
            } else if (log == null) {
                log = Output.stdOut();
            }
            return (Output)log;
        }

        void write(Grammar grammar, Path workingDir, Executor tool, Path path) throws IOException {
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                tool.execute(grammar, workingDir, out);
            }
        }

        private static interface Executor {
            public void execute(Grammar var1, Path var2, OutputStream var3);
        }
    }

    @Element(uri="http://opencypher.org/grammar/project", name="WG3Reference")
    static class WG3ReferenceFormat
    extends ReferenceFormat {
        @Attribute(optional=true)
        String standard;
        @Attribute(optional=true)
        String part;
        @Attribute
        String resolves;

        WG3ReferenceFormat() {
        }

        @Override
        Grammar.Resolver.WG3 resolver(Map<String, Grammar.Unresolved> grammars) {
            Grammar.Unresolved grammar = grammars.get(this.resolves);
            if (grammar == null) {
                throw new IllegalArgumentException("Undefined grammar: " + this.resolves);
            }
            return (standard, part, nonTerminal) -> Objects.equals(this.standard, standard) && Objects.equals(this.part, part) ? grammar.production(nonTerminal) : null;
        }
    }

    static abstract class ReferenceFormat {
        ReferenceFormat() {
        }

        abstract Grammar.Resolver resolver(Map<String, Grammar.Unresolved> var1);
    }

    @Element(uri="http://opencypher.org/grammar/project", name="option")
    static class Option {
        @Attribute
        String key;
        @Attribute
        String value;

        Option() {
        }
    }

    @Element(uri="http://opencypher.org/conditional", name="flag")
    static class Flag {
        @Attribute
        String name;

        Flag() {
        }
    }

    @Element(uri="http://opencypher.org/grammar/project", name="output")
    static class Target {
        @Attribute
        Tool tool;
        @Attribute
        String grammar;
        @Attribute
        Path path;
        final Map<String, Object> options = new HashMap<String, Object>();

        Target() {
        }

        @Child
        void option(Option option) {
            this.tool.addOption(this.options, option.key, option.value);
        }
    }

    @Element(uri="http://opencypher.org/grammar/project", name="grammar")
    static class Source {
        @Attribute
        String id;
        @Attribute
        XmlFile path;
        final List<ReferenceFormat> references = new ArrayList<ReferenceFormat>();
        final Set<String> flags = new HashSet<String>();

        Source() {
        }

        @Child(value={WG3ReferenceFormat.class})
        void reference(ReferenceFormat reference) {
            this.references.add(reference);
        }

        @Child
        void flag(Flag flag) {
            this.flags.add(flag.name);
        }

        Grammar.Resolver resolver(Map<String, Grammar.Unresolved> grammars) {
            Grammar.Resolver[] resolvers = new Grammar.Resolver[this.references.size()];
            for (int i = 0; i < resolvers.length; ++i) {
                resolvers[i] = this.references.get(i).resolver(grammars);
            }
            return Grammar.Resolver.combine(resolvers);
        }
    }
}

