/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.opencypher.grammar.Grammar;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.SVGShapes;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.tools.Option;
import org.opencypher.tools.grammar.Tool;
import org.opencypher.tools.io.Output;

public final class RailRoadDiagrams
extends Tool
implements ShapeRenderer.Linker {
    public static void main(String ... args) throws Exception {
        RailRoadDiagrams.main(RailRoadDiagrams::new, RailRoadDiagrams::generate, args);
    }

    private RailRoadDiagrams(Path workingDir, Map<?, ?> properties) {
        super(workingDir, properties);
    }

    private void generate(Grammar grammar, Output output) throws XMLStreamException, IOException {
        ShapeRenderer renderer = RailRoadDiagrams.renderer(this);
        Diagram.CanvasProvider<SVGShapes, XMLStreamException> canvas = RailRoadDiagrams.canvas(output, this.outputDir());
        for (Diagram diagram : Diagram.build(grammar, this.options(Diagram.BuilderOptions.class, new Option[0]))) {
            diagram.render(renderer, canvas);
        }
    }

    @Override
    public String referenceLink(String reference) {
        return reference + ".svg";
    }

    @Override
    public String charsetLink(String charset) {
        return RailRoadDiagrams.unicodesetLink(charset);
    }

    static <T extends Tool, EX extends Exception> ShapeRenderer<EX> renderer(T tool) {
        FontRenderContext fonts = new FontRenderContext(new AffineTransform(), true, true);
        return new ShapeRenderer((ShapeRenderer.Linker)tool, fonts, ((Tool)tool).options(ShapeRenderer.Options.class, new Option[0]));
    }

    static Diagram.CanvasProvider<SVGShapes, XMLStreamException> canvas(Output log, Path dir) {
        return SVGShapes.svgFile(name -> {
            String filename = name.replace('/', ' ');
            Path file = dir.resolve(filename + ".svg").toAbsolutePath();
            log.format("Writing Railroad diagram for %s to %s%n", name, file);
            return Output.output(file);
        });
    }

    static String unicodesetLink(String charset) {
        return Output.stringBuilder().append("http://unicode.org/cldr/utility/list-unicodeset.jsp?abb=on&esc=on&a=").escape(charset, c -> {
            switch (c) {
                case 58: {
                    return "%3A";
                }
                case 91: {
                    return "%5B";
                }
                case 92: {
                    return "%5C";
                }
                case 93: {
                    return "%5D";
                }
                case 94: {
                    return "%5E";
                }
            }
            return null;
        }).toString();
    }
}

