/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opencypher.grammar.Alternatives;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.Literal;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Optional;
import org.opencypher.grammar.Production;
import org.opencypher.grammar.Repetition;
import org.opencypher.grammar.Sequence;
import org.opencypher.grammar.TermTransformation;

class Recursive {
    final Production production;
    private final List<Trace> recursions;

    static List<Recursive> findLeftRecursive(Grammar grammar) {
        ArrayList<Recursive> result = new ArrayList<Recursive>();
        grammar.accept((Production production) -> {
            Builder builder = new Builder(true, production);
            production.definition().transform(builder, true);
            builder.addTo(result);
        });
        return result;
    }

    private Recursive(Production production, List<Trace> recursions) {
        this.production = production;
        this.recursions = recursions;
    }

    public void accept(TraceVisitor visitor) {
        for (Trace trace : this.recursions) {
            visitor.trace(this.production, trace.left, trace.trace);
        }
    }

    private static class Trail {
        private final Trail trail;
        private final Production production;

        Trail(Trail trail, Production production) {
            this.trail = trail;
            this.production = production;
        }

        boolean contains(Production production) {
            return this.production == production || this.trail != null && this.trail.contains(production);
        }

        Trace build(boolean left) {
            Production[] result = new Production[this.size()];
            this.populate(result, result.length - 1);
            return new Trace(left, result);
        }

        private int size() {
            return this.trail == null ? 1 : this.trail.size() + 1;
        }

        private void populate(Production[] result, int pos) {
            result[pos] = this.production;
            if (this.trail != null) {
                this.trail.populate(result, pos - 1);
            }
        }
    }

    private static class Builder
    implements TermTransformation<Boolean, Boolean, RuntimeException> {
        private final boolean leftOnly;
        private final Production root;
        private final Trail trail;
        private final List<Trace> recursions;
        private final Set<String> seen;

        Builder(boolean leftOnly, Production root) {
            this(leftOnly, new Trail(null, root), root, new ArrayList<Trace>(), new HashSet<String>());
        }

        private Builder(boolean leftOnly, Trail trail, Production root, List<Trace> recursions, Set<String> seen) {
            this.leftOnly = leftOnly;
            this.trail = trail;
            this.root = root;
            this.recursions = recursions;
            this.seen = seen;
        }

        void addTo(List<Recursive> result) {
            if (!this.recursions.isEmpty()) {
                result.add(new Recursive(this.root, this.recursions));
            }
        }

        private void traverse(Production production, Boolean first) {
            production.definition().transform(new Builder(this.leftOnly, new Trail(this.trail, production), this.root, this.recursions, this.seen), first);
        }

        @Override
        public Boolean transformNonTerminal(Boolean first, NonTerminal nonTerminal) {
            if (Objects.equals(this.root.name(), nonTerminal.productionName())) {
                this.recursions.add(this.trail.build(first));
            } else if (!this.trail.contains(nonTerminal.production())) {
                this.traverse(nonTerminal.production(), first);
            }
            return false;
        }

        @Override
        public Boolean transformAlternatives(Boolean first, Alternatives alternatives) {
            boolean stillFirst = first;
            for (Grammar.Term term : alternatives) {
                boolean possiblyEmpty = term.transform(this, first);
                stillFirst |= possiblyEmpty;
            }
            return stillFirst;
        }

        @Override
        public Boolean transformSequence(Boolean first, Sequence sequence) {
            for (Grammar.Term term : sequence) {
                first = term.transform(this, first);
                if (!this.leftOnly || first.booleanValue()) continue;
                return false;
            }
            return first;
        }

        @Override
        public Boolean transformOptional(Boolean first, Optional optional) {
            return first;
        }

        @Override
        public Boolean transformRepetition(Boolean first, Repetition repetition) {
            return first != false && repetition.minTimes() == 0;
        }

        @Override
        public Boolean transformEpsilon(Boolean first) {
            return first;
        }

        @Override
        public Boolean transformLiteral(Boolean first, Literal literal) {
            return false;
        }

        @Override
        public Boolean transformCharacters(Boolean first, CharacterSet characters) {
            return false;
        }
    }

    private static class Trace {
        private final boolean left;
        private final Production[] trace;

        Trace(boolean left, Production[] trace) {
            this.left = left;
            this.trace = trace;
        }
    }

    static interface TraceVisitor {
        public void trace(Production var1, boolean var2, Production[] var3);
    }
}

