/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.opencypher.generator.ChoicesFixture;
import org.opencypher.generator.Node;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.generator.TreeBuilder;
import org.opencypher.grammar.Grammar;

public class TreeBuilderTest {
    @Rule
    public final TestName testName = new TestName();
    private final ChoicesFixture random = new ChoicesFixture();
    private final Map<String, ProductionReplacement<Void>> replacements = new HashMap<String, ProductionReplacement<Void>>();
    private final TreeBuilder<Void> builder = new TreeBuilder(this.random.random(), () -> null, this.replacements);
    private Node.Tree actual;

    @Test
    public void shouldTransformLiteral() throws Exception {
        TreeBuilder.State<Void> next = this.generate(Grammar.literal((String)"hello"));
        Node.Tree expected = this.tree();
        expected.literal((CharSequence)"hello");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformEpsilon() throws Exception {
        TreeBuilder.State<Void> next = this.generate(Grammar.epsilon());
        Assert.assertEquals((Object)this.tree(), (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformSequence() throws Exception {
        TreeBuilder.State<Void> next = this.generate(Grammar.sequence((Grammar.Term)Grammar.literal((String)"a"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"b"), Grammar.literal((String)"c")}));
        Node.Tree expected = this.tree();
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"a");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"b");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"c");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformAlternatives() throws Exception {
        this.random.pick("c");
        TreeBuilder.State<Void> next = this.generate(Grammar.oneOf((Grammar.Term)Grammar.literal((String)"a"), (Grammar.Term[])new Grammar.Term[]{Grammar.literal((String)"b"), Grammar.literal((String)"c")}));
        Node.Tree expected = this.tree();
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"c");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformIncludedOptional() throws Exception {
        this.random.includeOptional();
        TreeBuilder.State<Void> next = this.generate(Grammar.optional((Grammar.Term)Grammar.literal((String)"ok"), (Grammar.Term[])new Grammar.Term[0]));
        Node.Tree expected = this.tree();
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"ok");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformExcludedOptional() throws Exception {
        this.random.excludeOptional();
        TreeBuilder.State<Void> next = this.generate(Grammar.optional((Grammar.Term)Grammar.literal((String)"not"), (Grammar.Term[])new Grammar.Term[0]));
        Node.Tree expected = this.tree();
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformRepetition() throws Exception {
        this.random.repeat(3, ChoicesFixture.onRepetition(1));
        TreeBuilder.State<Void> next = this.generate(Grammar.oneOrMore((Grammar.Term)Grammar.literal((String)"hej"), (Grammar.Term[])new Grammar.Term[0]));
        Node.Tree expected = this.tree();
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"hej");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"hej");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        expected.literal((CharSequence)"hej");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    @Test
    public void shouldTransformCharacterSet() throws Exception {
        class CharSet {
            final String name;
            final String expected;

            CharSet(String name, int c) {
                this.name = name;
                this.expected = "" + (char)c;
            }
        }
        for (CharSet charset : new CharSet[]{new CharSet("NUL", 0), new CharSet("SOH", 1), new CharSet("STX", 2), new CharSet("ETX", 3), new CharSet("EOT", 4), new CharSet("ENQ", 5), new CharSet("ACK", 6), new CharSet("BEL", 7), new CharSet("BS", 8), new CharSet("TAB", 9), new CharSet("LF", 10), new CharSet("VT", 11), new CharSet("FF", 12), new CharSet("CR", 13), new CharSet("SO", 14), new CharSet("SI", 15), new CharSet("DLE", 16), new CharSet("DC1", 17), new CharSet("DC2", 18), new CharSet("DC3", 19), new CharSet("DC4", 20), new CharSet("NAK", 21), new CharSet("SYN", 22), new CharSet("ETB", 23), new CharSet("CAN", 24), new CharSet("EM", 25), new CharSet("SUB", 26), new CharSet("ESC", 27), new CharSet("FS", 28), new CharSet("GS", 29), new CharSet("RS", 30), new CharSet("US", 31), new CharSet("SPACE", 32), new CharSet("DEL", 127)}) {
            TreeBuilder.State<Void> next = this.generate((Grammar.Term)Grammar.charactersOfSet((String)charset.name));
            Node.Tree expected = this.tree();
            expected.literal((CharSequence)charset.expected);
            Assert.assertEquals((String)charset.name, (Object)expected, (Object)this.actual);
            Assert.assertNull(next);
        }
    }

    @Test
    public void shouldTransformNonTerminal() throws Exception {
        Grammar.Term nonTerminal = (Grammar.Term)Grammar.grammar((String)this.testName.getMethodName(), (Grammar.Option[])new Grammar.Option[0]).production(this.testName.getMethodName(), Grammar.nonTerminal((String)"other"), new Grammar.Term[0]).production("other", Grammar.literal((String)"done"), new Grammar.Term[0]).build(new Grammar.Builder.Option[0]).transform(this.testName.getMethodName(), (param, prod) -> prod.definition(), null);
        TreeBuilder.State<Void> next = this.generate(nonTerminal);
        Node.Tree expected = this.tree();
        Node.Tree other = expected.child("other");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNotNull(next);
        next = this.generate(next);
        other.literal((CharSequence)"done");
        Assert.assertEquals((Object)expected, (Object)this.actual);
        Assert.assertNull(next);
    }

    private TreeBuilder.State<Void> generate(Grammar.Term term) {
        this.actual = this.tree();
        return this.generate((TreeBuilder.State<Void>)TreeBuilder.state((Grammar.Term)term, (Node.Tree)this.actual, null));
    }

    private TreeBuilder.State<Void> generate(TreeBuilder.State<Void> state) {
        return state.generate(this.builder);
    }

    private Node.Tree tree() {
        return Node.root((String)this.testName.getMethodName());
    }
}

