/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.generator;

import java.util.Objects;
import java.util.function.Consumer;
import org.opencypher.generator.ProductionReplacement;
import org.opencypher.tools.io.Output;

public abstract class Node {
    private final Node parent;
    private final String name;
    private Node next;

    static Tree root(String language) {
        return new Tree(null, Objects.requireNonNull(language, "language"));
    }

    private Node(Node parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public final Node parent() {
        return this.parent;
    }

    public void write(Output output) {
        Node child = this.children();
        while (child != null) {
            child.write(output);
            child = child.next;
        }
    }

    public final int hashCode() {
        int hash = Objects.hashCode(this.name);
        int detail = this.hash();
        if (detail != 0) {
            hash = hash * 31 + detail;
        }
        Node child = this.children();
        while (child != null) {
            hash = hash * 31 + child.hashCode();
            child = child.next;
        }
        return hash;
    }

    int hash() {
        return 0;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass() || !this.eq((Node)obj)) {
            return false;
        }
        Node these = this.children();
        Node those = ((Node)obj).children();
        while (these != null && those != null) {
            if (!these.equals(those)) {
                return false;
            }
            these = these.next;
            those = those.next;
        }
        return these == those;
    }

    boolean eq(Node obj) {
        return true;
    }

    public final String toString() {
        Output.Readable result = Output.stringBuilder();
        this.toString(result);
        return result.toString();
    }

    public final void sExpression(Output output) {
        this.sExpression(output, 0);
    }

    void toString(Output result) {
        result.append(this.getClass().getSimpleName()).append('{').append(this.name());
        String sep = ": ";
        Node child = this.children();
        while (child != null) {
            result.append(sep);
            child.toString(result);
            sep = ", ";
            child = child.next;
        }
        result.append('}');
    }

    void sExpression(Output output, int indent) {
        indent += 2;
        output.append('(').append(this.name());
        Node child = this.children();
        if (child != null && child.next == null) {
            output.append(' ');
            child.sExpression(output, indent);
        } else {
            while (child != null) {
                output.println();
                for (int space = 0; space < indent; ++space) {
                    output.append(' ');
                }
                child.sExpression(output, indent);
                child = child.next;
            }
        }
        output.append(')');
    }

    Node append(String literal) {
        return this.append(new Literal(this.parent())).append(literal);
    }

    Node appendCodePoint(int cp) {
        return this.append(new Literal(this.parent())).appendCodePoint(cp);
    }

    Node children() {
        return null;
    }

    public final String name() {
        return this.name;
    }

    final Node append(Node node) {
        assert (this.next == null) : "appending to the middle of the chain";
        this.next = node;
        return node;
    }

    private static class ReplacementContext<T>
    implements ProductionReplacement.Context<T> {
        private final Replacement<T> replacement;
        private final Output output;

        private ReplacementContext(Replacement<T> replacement, Output output) {
            this.replacement = replacement;
            this.output = output;
        }

        @Override
        public Node node() {
            return this.replacement;
        }

        @Override
        public void generateDefault() {
            Tree tree = new Tree(this.replacement.parent(), this.replacement.name());
            this.replacement.defaults.accept(tree);
            tree.write(this.output);
        }

        @Override
        public T context() {
            return this.replacement.context;
        }

        @Override
        public void write(CharSequence str) {
            this.output.append(str);
        }

        @Override
        public void write(int codePoint) {
            this.output.appendCodePoint(codePoint);
        }

        @Override
        public Output output() {
            return this.output;
        }
    }

    private static class Replacement<T>
    extends Node {
        private final ProductionReplacement<T> replacement;
        private final T context;
        private final Consumer<Tree> defaults;

        private Replacement(Node parent, String name, ProductionReplacement<T> replacement, T context, Consumer<Tree> defaults) {
            super(parent, name);
            this.replacement = replacement;
            this.context = context;
            this.defaults = defaults;
        }

        @Override
        public void write(Output output) {
            this.replacement.replace(new ReplacementContext(this, output));
        }

        @Override
        int hash() {
            return this.replacement.hashCode() * 31 + Objects.hashCode(this.context);
        }

        @Override
        boolean eq(Node obj) {
            Replacement that = (Replacement)obj;
            return Objects.equals(this.replacement, that.replacement) && Objects.equals(this.context, that.context);
        }
    }

    private static class Literal
    extends Node {
        private final StringBuilder buffer = new StringBuilder();

        private Literal(Node parent) {
            super(parent, null);
        }

        @Override
        int hash() {
            int hash = 0;
            int i = this.buffer.length();
            while (i-- > 0) {
                hash = hash * 31 + this.buffer.charAt(i);
            }
            return hash;
        }

        @Override
        boolean eq(Node obj) {
            Literal that = (Literal)obj;
            int len = this.buffer.length();
            if (that.buffer.length() != len) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (this.buffer.charAt(i) == that.buffer.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        Node append(String literal) {
            this.buffer.append(literal);
            return this;
        }

        @Override
        Node appendCodePoint(int cp) {
            this.buffer.appendCodePoint(cp);
            return this;
        }

        @Override
        public void write(Output output) {
            output.append(this.buffer);
        }

        @Override
        void toString(Output result) {
            result.append('\'').append(this.buffer.toString().replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t")).append('\'');
        }

        @Override
        void sExpression(Output output, int indent) {
            this.toString(output);
        }
    }

    static class Tree
    extends Node {
        private Node first;
        private Node last;

        private Tree(Node parent, String name) {
            super(parent, name);
        }

        @Override
        Node children() {
            return this.first;
        }

        public Tree child(String name) {
            return this.add(new Tree(this, Objects.requireNonNull(name, "name")));
        }

        public void literal(CharSequence literal) {
            if (this.last == null) {
                this.first = this.last = new Literal(this);
            }
            this.last = this.last.append(literal.toString());
        }

        public void codePoint(int cp) {
            if (this.last == null) {
                this.first = this.last = new Literal(this);
            }
            this.last = this.last.appendCodePoint(cp);
        }

        public <T> void production(String name, ProductionReplacement<T> replacement, T context, Consumer<Tree> defaultValue) {
            this.add(new Replacement<T>(this, name, replacement, context, defaultValue));
        }

        private <T extends Node> T add(T child) {
            if (this.last == null) {
                this.first = this.last = child;
            } else {
                this.last = this.last.append(child);
            }
            return child;
        }
    }
}

