/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.grammar;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.opencypher.grammar.Conditional;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.GrammarAnnotation;
import org.opencypher.grammar.ProductionNode;
import org.opencypher.grammar.ProductionTransformation;
import org.opencypher.grammar.Root;
import org.opencypher.grammar.WG3Grammar;
import org.opencypher.tools.xml.Attribute;
import org.opencypher.tools.xml.XmlFile;
import org.opencypher.tools.xml.XmlParser;
import org.xml.sax.SAXException;

abstract class ProtoGrammar {
    static final Grammar.Resolver NO_RESOLVER = reference -> null;

    ProtoGrammar() {
    }

    static ProtoGrammar parse(Path input, XmlParser.Option ... options) throws ParserConfigurationException, SAXException, IOException {
        return Parsing.XML.parse(input, options);
    }

    static ProtoGrammar parse(Reader input, XmlParser.Option ... options) throws ParserConfigurationException, SAXException, IOException {
        return Parsing.XML.parse(input, options);
    }

    static ProtoGrammar parse(InputStream input, XmlParser.Option ... options) throws IOException, SAXException, ParserConfigurationException {
        return Parsing.XML.parse(input, options);
    }

    static ProtoGrammar parse(XmlFile file) throws IOException, SAXException, ParserConfigurationException {
        return file.parse(Parsing.XML);
    }

    abstract String language();

    abstract ProductionNode production(String var1);

    abstract void setName(String var1);

    final Grammar resolve(Grammar.Resolver resolver, ResolutionOption ... config) {
        EnumSet<ResolutionOption> options = EnumSet.noneOf(ResolutionOption.class);
        if (config != null) {
            Collections.addAll(options, config);
        }
        return this.resolve(resolver, options);
    }

    abstract Grammar resolve(Grammar.Resolver var1, Set<ResolutionOption> var2);

    abstract void add(ProductionNode var1);

    abstract void apply(Patch var1);

    private static class Parsing {
        static final XmlParser<ProtoGrammar> XML = XmlParser.combine(ProtoGrammar.class, Root.XML, WG3Grammar.XML, GrammarAnnotation.XML);

        private Parsing() {
        }
    }

    static abstract class Mutator {
        Mutator() {
        }

        abstract <P, EX extends Exception> void replaceProduction(String var1, ProductionTransformation<P, ProductionNode, EX> var2, P var3) throws EX;

        abstract void removeProduction(String var1);

        abstract Collection<String> productions();
    }

    static abstract class Patch {
        private Conditional conditional = Conditional.NONE;

        Patch() {
        }

        abstract void apply(Mutator var1);

        @Attribute(optional=true, uri="http://opencypher.org/conditional")
        void given(String flag) {
            this.conditional = this.conditional.given(flag);
        }

        @Attribute(optional=true, uri="http://opencypher.org/conditional")
        void unless(String flag) {
            this.conditional = this.conditional.unless(flag);
        }
    }

    static enum ResolutionOption {
        ALLOW_ROOTLESS,
        SKIP_UNUSED_PRODUCTIONS,
        IGNORE_UNUSED_PRODUCTIONS,
        INCLUDE_LEGACY;

    }
}

