/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.railroad;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.opencypher.railroad.Diagram;
import org.opencypher.railroad.ShapeRenderer;
import org.opencypher.railroad.TextGlyphs;

public final class AwtShapes
implements ShapeRenderer.Shapes<RuntimeException> {
    public static final Diagram.CanvasProvider<AwtShapes, RuntimeException> AWT = AwtShapes::new;
    private final String name;
    private final double width;
    private final double height;
    private final List<Element> elements = new ArrayList<Element>();

    private AwtShapes(String name, double width, double height) {
        this.name = name;
        this.width = width;
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void render(Graphics2D target) {
        for (Element element : this.elements) {
            element.render(target);
        }
    }

    @Override
    public void roundRect(ShapeRenderer.Shapes.Style style, double x, double y, double width, double height, double diameter) {
        this.elements.add(new ShapeElement(style, new RoundRectangle2D.Double(x, y, width, height, diameter, diameter)));
    }

    @Override
    public void rect(ShapeRenderer.Shapes.Style style, double x, double y, double width, double height) {
        this.elements.add(new ShapeElement(style, new Rectangle2D.Double(x, y, width, height)));
    }

    @Override
    public void arc(ShapeRenderer.Shapes.Style style, double cx, double cy, double radius, double start, double extent) {
        double diameter = radius * 2.0;
        double x = cx - radius;
        double y = cy - radius;
        if (extent >= 360.0 || extent <= -360.0) {
            this.elements.add(new ShapeElement(style, new Ellipse2D.Double(x, y, diameter, diameter)));
        } else {
            this.elements.add(new ShapeElement(style, new Arc2D.Double(x, y, diameter, diameter, start, extent, 0)));
        }
    }

    @Override
    public void line(ShapeRenderer.Shapes.Style style, double x1, double y1, double x2, double y2) {
        this.elements.add(new ShapeElement(ShapeRenderer.Shapes.Style.OUTLINE, new Line2D.Double(x1, y1, x2, y2)));
    }

    @Override
    public void polygon(ShapeRenderer.Shapes.Style style, ShapeRenderer.Shapes.Point ... points) {
        int[] x = new int[points.length];
        int[] y = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            x[i] = (int)Math.round(points[i].x);
            y[i] = (int)Math.round(points[i].y);
        }
        this.elements.add(new ShapeElement(style, new Polygon(x, y, points.length)));
    }

    @Override
    public void text(TextGlyphs text, double x, double y) {
        this.elements.add(new TextElement(x, y, text));
    }

    @Override
    public ShapeRenderer.Shapes.Path<RuntimeException> path(ShapeRenderer.Shapes.Style style) {
        return new LinePath(style);
    }

    private static class PathPosition {
        final double x;
        final double y;

        PathPosition(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private class LinePath
    implements ShapeRenderer.Shapes.Path<RuntimeException> {
        private final ShapeRenderer.Shapes.Style style;
        private PathPosition start;
        double x;
        double y;

        public LinePath(ShapeRenderer.Shapes.Style style) {
            this.style = style;
        }

        @Override
        public void arc(double rx, double ry, double xAxisRotation, boolean largeArc, boolean sweep, double x, double y) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void closePath() {
            if (this.start != null) {
                this.lineTo(this.start.x, this.start.y);
            }
        }

        @Override
        public void moveTo(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void lineTo(double x, double y) {
            if (this.start == null) {
                this.start = new PathPosition(this.x, this.y);
            }
            AwtShapes.this.line(this.style, this.x, this.y, x, y);
            this.x = x;
            this.y = y;
        }

        @Override
        public void quadTo(double x1, double y1, double x2, double y2) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void cubicTo(double x1, double y1, double x2, double y2, double x3, double y3) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void close() throws RuntimeException {
        }
    }

    private static class TextElement
    extends Element {
        private final double x;
        private final double y;
        private final TextGlyphs text;

        TextElement(double x, double y, TextGlyphs text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }

        @Override
        void render(Graphics2D target) {
            target.setFont(this.text.getFont());
            target.drawString(this.text.text(), this.text.offsetX(this.x), this.text.offsetY(this.y));
        }
    }

    private static class ShapeElement
    extends Element {
        private final ShapeRenderer.Shapes.Style style;
        private final Shape shape;

        ShapeElement(ShapeRenderer.Shapes.Style style, Shape shape) {
            this.style = style;
            this.shape = shape;
        }

        @Override
        void render(Graphics2D target) {
            if (this.style.stroke) {
                target.draw(this.shape);
            }
            if (this.style.fill) {
                target.fill(this.shape);
            }
        }
    }

    private static abstract class Element {
        private Element() {
        }

        abstract void render(Graphics2D var1);
    }
}

