/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum BnfSymbols {
    ASSIGN("::="),
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LEFT_BRACE("{", "\\{"),
    RIGHT_BRACE("}", "\\}"),
    LEFT_BRACKET("[", "\\["),
    RIGHT_BRACKET("]", "\\]"),
    ELLIPSIS("...", "\\.\\.\\."),
    DOUBLE_EXCLAM("!!", "!!", "\\!\\!"),
    VERTICAL_BAR("|", "\\|"),
    DOLLAR("$", "\\$"),
    REVERSE_SOLIDUS("\\", "\\\\");

    private final String actualCharacters;
    private final String bnfForm;
    private final String g4Name;
    private final String bnfName;
    private String regexChars;
    private static final Map<String, BnfSymbols> charMap;
    private static final Map<String, BnfSymbols> bnfNameMap;
    private static final Pattern bnfAnyPattern;
    private static final Pattern bnfAllPattern;

    public String getActualCharacters() {
        return this.actualCharacters;
    }

    public String getBnfForm() {
        return this.bnfForm;
    }

    public String getG4Name() {
        return this.g4Name;
    }

    public String getBnfName() {
        return this.bnfName;
    }

    private BnfSymbols(String characters) {
        this(characters, characters, characters);
    }

    private BnfSymbols(String characters, String escapedCharacters) {
        this(characters, escapedCharacters, characters);
    }

    private BnfSymbols(String characters, String escapedCharacters, String bnfOutcharacters) {
        this.actualCharacters = characters;
        this.bnfForm = bnfOutcharacters;
        this.regexChars = escapedCharacters;
        this.bnfName = this.name().toLowerCase().replaceAll("_", " ");
        this.g4Name = this.name();
    }

    public static BnfSymbols getByValue(String characters) {
        return charMap.get(characters);
    }

    public static BnfSymbols getByName(String bnfName) {
        return bnfNameMap.get(bnfName);
    }

    public static boolean allBnfSymbols(String subject) {
        Matcher m = bnfAllPattern.matcher(subject);
        return m.matches();
    }

    public static boolean anyBnfSymbols(String subject) {
        return bnfAnyPattern.matcher(subject).find();
    }

    public static Interleaver getInterleave(String value) {
        Matcher m = bnfAnyPattern.matcher(value);
        int begin = 0;
        final ArrayList<String> text = new ArrayList<String>();
        final ArrayList<BnfSymbols> symbols = new ArrayList<BnfSymbols>();
        while (m.find()) {
            int s = m.start();
            if (s > begin) {
                text.add(value.substring(begin, s));
            } else {
                text.add("");
            }
            symbols.add(BnfSymbols.getByValue(m.group()));
            begin = m.end();
        }
        if (begin < value.length()) {
            text.add(value.substring(begin));
        } else {
            text.add("");
        }
        return new Interleaver(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < symbols.size();
            }

            @Override
            public String nextText() {
                return (String)text.get(this.i);
            }

            @Override
            public BnfSymbols nextSymbol() {
                return (BnfSymbols)((Object)symbols.get(this.i++));
            }
        };
    }

    static {
        charMap = new HashMap<String, BnfSymbols>();
        bnfNameMap = new HashMap<String, BnfSymbols>();
        ArrayList<String> bnfSyms = new ArrayList<String>();
        for (BnfSymbols lit : BnfSymbols.values()) {
            charMap.put(lit.actualCharacters, lit);
            bnfNameMap.put(lit.bnfName, lit);
            charMap.put(lit.bnfForm, lit);
            bnfSyms.add(lit.regexChars);
        }
        String pattern = bnfSyms.stream().collect(Collectors.joining("|"));
        bnfAnyPattern = Pattern.compile("(" + pattern + ")");
        bnfAllPattern = Pattern.compile("(?:" + pattern + ")+");
    }

    public static interface Interleaver {
        public boolean hasNext();

        public String nextText();

        public BnfSymbols nextSymbol();
    }
}

