/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.g4tree;

import java.util.Collections;
import java.util.List;
import org.opencypher.tools.g4tree.GrammarItem;
import org.opencypher.tools.g4tree.GrammarName;
import org.opencypher.tools.g4tree.RuleList;

public class GrammarTop
implements GrammarItem {
    private final GrammarName name;
    private final RuleList rules;
    private final String header;

    public GrammarTop(GrammarName name, RuleList rules, String header) {
        this.name = name;
        this.rules = rules;
        this.header = header;
    }

    @Override
    public GrammarItem.ItemType getType() {
        return GrammarItem.ItemType.OTHER;
    }

    @Override
    public List<GrammarItem> getChildren() {
        return Collections.singletonList(this.rules);
    }

    public String getName() {
        return this.name.getName();
    }

    public RuleList getRuleList() {
        return this.rules;
    }

    public String getHeader() {
        return this.header;
    }

    @Override
    public String getStructure(String indent) {
        return "Grammar " + this.name.getStructure("") + "\n" + this.rules.getStructure(indent);
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    @Override
    public GrammarItem reachThrough() {
        return this;
    }

    @Override
    public boolean isKeywordPart() {
        return false;
    }
}

