/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.grammar;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import org.opencypher.grammar.CharacterSet;
import org.opencypher.grammar.Grammar;
import org.opencypher.grammar.NonTerminal;
import org.opencypher.grammar.Production;
import org.opencypher.tools.grammar.BnfWriter;
import org.opencypher.tools.grammar.HtmlLinker;
import org.opencypher.tools.grammar.Main;
import org.opencypher.tools.io.HtmlTag;
import org.opencypher.tools.io.Output;

public class ISO14977
extends BnfWriter {
    public static void write(Grammar grammar, Writer writer) {
        ISO14977.write(grammar, Output.output(writer));
    }

    public static void write(Grammar grammar, Path workingDir, OutputStream stream) {
        ISO14977.write(grammar, Output.output(stream));
    }

    public static void write(Grammar grammar, Output output) {
        String header = grammar.header();
        if (header != null) {
            output.append("(*\n * ").printLines(header, " * ").println(" *)");
        }
        try (ISO14977 writer = new ISO14977(output);){
            grammar.accept(writer);
        }
    }

    public static void main(String ... args) throws Exception {
        Main.execute(ISO14977::write, args);
    }

    public static void append(Grammar.Term term, Output output) {
        term.accept(new ISO14977(output));
    }

    public static void append(Production production, Output output) {
        new ISO14977(output){

            @Override
            protected void productionEnd() {
                this.output.println(" ;");
            }
        }.visitProduction(production);
    }

    public static Output string(Output str, Production production) {
        return str.append(production.definition(), ISO14977::append);
    }

    public static void html(HtmlTag parent, Production production, HtmlLinker linker) {
        try (HtmlTag pre = parent.tag("pre", new HtmlTag.Attribute[0]);
             HtmlTag code = pre.tag("code", new HtmlTag.Attribute[0]);){
            new Html(code, linker).visitProduction(production);
        }
    }

    private ISO14977(Output output) {
        super(output);
    }

    @Override
    protected void productionCommentPrefix() {
        this.output.append("(* ");
    }

    @Override
    protected void productionCommentLinePrefix() {
        this.output.append(" * ");
    }

    @Override
    protected void productionCommentSuffix() {
        this.output.append(" *)");
    }

    @Override
    protected void productionStart(Production p) {
        this.output.append(p.name()).append(" = ");
    }

    @Override
    protected String prefix(String s) {
        return s;
    }

    @Override
    protected void productionEnd() {
        this.output.println(" ;").println();
    }

    @Override
    protected void alternativesLinePrefix(int altPrefix) {
        if (altPrefix > 0) {
            this.output.println();
            while (altPrefix-- > 0) {
                this.output.append(' ');
            }
        }
    }

    @Override
    protected void alternativesSeparator() {
        this.output.append(" | ");
    }

    @Override
    protected void sequenceSeparator() {
        this.output.append(", ");
    }

    @Override
    protected void literal(String value) {
        this.enclose(value);
    }

    @Override
    protected void caseInsensitive(String value) {
        this.group(() -> {
            int cp;
            String sep = "";
            int start = 0;
            int end = value.length();
            for (int i = 0; i < end; i += Character.charCount(cp)) {
                cp = value.charAt(i);
                if (!Character.isLowerCase(cp) && !Character.isUpperCase(cp) && !Character.isTitleCase(cp)) continue;
                if (start < i) {
                    this.output.append(sep);
                    sep = ",";
                    this.enclose(value.substring(start, i));
                }
                this.output.append(sep);
                sep = ",";
                start = i + Character.charCount(cp);
                cp = Character.toUpperCase(cp);
                this.addCaseChar(cp);
                this.appendCaseChar(cp);
            }
            if (start < value.length()) {
                this.output.append(sep);
                this.enclose(value.substring(start));
            }
        });
    }

    void appendCaseChar(int cp) {
        this.output.appendCodePoint(cp);
    }

    private void enclose(String value) {
        char enclose;
        int sq = value.indexOf(39);
        if (sq == -1) {
            enclose = '\'';
        } else {
            int dq = value.indexOf(34);
            if (dq == -1) {
                enclose = '\"';
            } else {
                char other;
                char enclose2;
                if (sq < dq) {
                    sq = dq;
                    enclose2 = '\"';
                    other = '\'';
                } else {
                    enclose2 = '\'';
                    other = '\"';
                }
                int _sq = sq;
                this.group(() -> this.encloseGroupElements(value, enclose2, _sq, other));
                return;
            }
        }
        this.output.append(enclose).append(value).append(enclose);
    }

    private void encloseGroupElements(String value, char enclose, int sq, char other) {
        int start = 0;
        int end = sq;
        while (end != -1) {
            this.output.append(enclose).append(value.subSequence(start, end)).append(enclose).append(", ");
            char last = enclose;
            enclose = other;
            other = last;
            start = end;
            end = value.indexOf(enclose, end + 1);
        }
        this.output.append(enclose).append(value.subSequence(start, value.length())).append(enclose);
    }

    @Override
    protected void caseInsensitiveProductionStart(String name) {
        this.output.append(name).append(" = ");
    }

    @Override
    protected void epsilon() {
    }

    @Override
    protected void characterSet(CharacterSet characters) {
        String name = characters.name();
        if (name != null) {
            this.output.append(name);
        } else {
            characters.accept(new CharacterSet.DefinitionVisitor.NamedSetVisitor<RuntimeException>(){
                String sep = "";

                @Override
                public CharacterSet.ExclusionVisitor<RuntimeException> visitSet(String name) {
                    ISO14977.this.output.append(name);
                    return new CharacterSet.ExclusionVisitor<RuntimeException>(){
                        String sep = " - (";

                        @Override
                        public void excludeCodePoint(int cp) throws RuntimeException {
                            ISO14977.this.output.append(this.sep);
                            this.codePoint(cp);
                            this.sep = " | ";
                        }

                        @Override
                        public void excludeSet(String name) {
                            ISO14977.this.output.append(this.sep).append(name);
                            this.sep = " | ";
                        }

                        @Override
                        public void close() throws RuntimeException {
                            if (this.sep.charAt(this.sep.length() - 1) != '(') {
                                ISO14977.this.output.append(')');
                            }
                        }
                    };
                }

                @Override
                public void visitCodePoint(int cp) {
                    ISO14977.this.output.append(this.sep);
                    this.codePoint(cp);
                    this.sep = " | ";
                }

                private void codePoint(int cp) {
                    String controlChar = CharacterSet.controlCharName(cp);
                    if (controlChar != null) {
                        ISO14977.this.output.append(controlChar);
                    } else if (cp == 39) {
                        ISO14977.this.output.append("\"'\"");
                    } else {
                        ISO14977.this.output.append('\'').appendCodePoint(cp).append('\'');
                    }
                }
            });
        }
    }

    @Override
    protected void nonTerminal(NonTerminal nonTerminal) {
        this.output.append(nonTerminal.productionName());
    }

    @Override
    protected boolean optionalPrefix() {
        this.output.append("[");
        return true;
    }

    @Override
    protected void optionalSuffix() {
        this.output.append("]");
    }

    @Override
    protected void repeat(int minTimes, Integer maxTimes, Runnable repeated) {
        if (maxTimes == null) {
            if (minTimes == 0 || minTimes == 1) {
                this.groupWith('{', repeated, '}');
                if (minTimes == 1) {
                    this.output.append('-');
                }
            } else {
                this.group(() -> {
                    this.output.append(minTimes).append(" * ");
                    repeated.run();
                    this.output.append(", ");
                    this.groupWith('{', repeated, '}');
                });
            }
        } else if (minTimes == maxTimes) {
            this.output.append(minTimes).append(" * ");
            this.groupWithoutPrefix(repeated);
        } else if (minTimes > 0) {
            this.group(() -> {
                this.output.append(minTimes).append(" * ");
                repeated.run();
                this.output.append(", ");
                this.output.append(maxTimes - minTimes).append(" * ");
                this.groupWith('[', repeated, ']');
            });
        } else {
            this.output.append(maxTimes - minTimes).append(" * ");
            this.groupWith('[', repeated, ']');
        }
    }

    @Override
    protected void groupPrefix() {
        this.output.append('(');
    }

    @Override
    protected void groupSuffix() {
        this.output.append(')');
    }

    private static class Html
    extends ISO14977 {
        private final HtmlTag html;
        private final HtmlLinker linker;

        Html(HtmlTag html, HtmlLinker linker) {
            super(html.textOutput());
            this.html = html;
            this.linker = linker;
        }

        @Override
        protected void nonTerminal(NonTerminal nonTerminal) {
            try (HtmlTag ignored = this.link(this.linker.referenceLink(nonTerminal));){
                super.nonTerminal(nonTerminal);
            }
        }

        @Override
        protected void characterSet(CharacterSet characters) {
            try (HtmlTag ignored = this.link(this.linker.charsetLink(characters));){
                super.characterSet(characters);
            }
        }

        @Override
        protected void literal(String value) {
            try (HtmlTag ignored = this.link(this.literalLink(value));){
                super.literal(value);
            }
        }

        @Override
        void appendCaseChar(int cp) {
            int lo = Character.toLowerCase(cp);
            int up = Character.toUpperCase(cp);
            int title = Character.toTitleCase(cp);
            Output.Readable link = Output.stringBuilder();
            link.append('[').format("[\\u%04X]", lo);
            if (up != lo) {
                link.format("[\\u%04X]", up);
            }
            if (title != up && title != lo) {
                link.format("[\\u%04X]", title);
            }
            try (HtmlTag ignored = this.link(this.linker.charsetLink(link.append(']').toString()));){
                super.appendCaseChar(cp);
            }
        }

        private HtmlTag link(String target) {
            return target == null ? null : this.html.tag("a", HtmlTag.attr("href", target));
        }

        private String literalLink(String literal) {
            if (!literal.isEmpty()) {
                int cp = literal.codePointAt(0);
                if (literal.length() == Character.charCount(cp)) {
                    return this.linker.charsetLink(String.format("[\\u%04X]", cp));
                }
            }
            return null;
        }

        @Override
        protected void productionEnd() {
            this.output.println(" ;");
        }
    }
}

