/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.io;

import java.io.Serializable;
import java.nio.file.Path;
import org.opencypher.tools.io.Output;

public final class HtmlTag
implements AutoCloseable {
    private final Output output;
    private final String tag;

    public static Html html(Path file) {
        return HtmlTag.html(Output.output(file));
    }

    public static Html html(Output output) {
        return new Html(output);
    }

    public final HtmlTag tag(String tag, Attribute ... attributes) {
        this.output.append('<').append(tag);
        for (Attribute attribute : attributes) {
            String value = attribute.value();
            if (value == null) continue;
            this.output.append(' ').append(attribute.name()).append("=\"").append(value).append('\"');
        }
        this.output.append('>');
        return new HtmlTag(this.output, tag);
    }

    public HtmlTag text(String text) {
        this.output.escape(text, c -> c == 60 ? "&lt;" : null);
        return this;
    }

    public HtmlTag textTag(String tag, String text, Attribute ... attributes) {
        try (HtmlTag html = this.tag(tag, attributes);){
            html.text(text);
        }
        return this;
    }

    public HtmlTag a(String href, String text) {
        return this.textTag("a", text, HtmlTag.attr("href", href));
    }

    public void p(String text) {
        this.output.append("<p>");
        this.text(text);
        this.output.append("</p>");
    }

    public void br() {
        this.output.append("<br>");
    }

    public static Attribute attr(final String attribute, final String value) {
        return new Attribute(){

            @Override
            public String name() {
                return attribute;
            }

            @Override
            public String value() {
                return value;
            }
        };
    }

    public static HeadTag meta(String name, String value) {
        return HtmlTag.head("meta", null, HtmlTag.attr(name, value));
    }

    public static HeadTag head(String tag, String text, Attribute ... attributes) {
        return new HeadTag(tag, text, attributes);
    }

    private HtmlTag(Output output, String tag) {
        this.output = output;
        this.tag = tag;
    }

    @Override
    public void close() {
        this.output.format("</%s>", this.tag);
    }

    public Output textOutput() {
        return new Output(){

            @Override
            public Output append(char x) {
                if (x == '<') {
                    HtmlTag.this.output.append("&lt;");
                } else {
                    HtmlTag.this.output.append(x);
                }
                return this;
            }
        };
    }

    public static final class HeadTag {
        private final String tag;
        private final String text;
        private final Attribute[] attributes;

        private HeadTag(String tag, String text, Attribute[] attributes) {
            this.tag = tag;
            this.text = text;
            this.attributes = attributes;
        }
    }

    public static final class Html
    implements AutoCloseable {
        private State state = State.EMIT_HEAD;
        private final HtmlTag html;

        public final void head(HeadTag ... tags) {
            this.state = this.state.head();
            try (HtmlTag head = this.html.tag("head", new Attribute[0]);){
                for (HeadTag tag : tags) {
                    try (HtmlTag headTag = head.tag(tag.tag, tag.attributes);){
                        if (tag.text == null) continue;
                        headTag.text(tag.text);
                    }
                }
            }
        }

        public HtmlTag body() {
            this.state = this.state.body();
            return this.html.tag("body", new Attribute[0]);
        }

        private Html(Output output) {
            output.append("<html>");
            this.html = new HtmlTag(output, "html");
        }

        @Override
        public void close() {
            this.state = this.state.close();
            this.html.close();
            this.html.output.close();
        }

        private static enum State {
            EMIT_HEAD{

                @Override
                State head() {
                    return EMIT_BODY;
                }

                @Override
                State body() {
                    return SHOULD_CLOSE;
                }

                @Override
                State close() {
                    return CLOSED;
                }
            }
            ,
            EMIT_BODY{

                @Override
                State head() {
                    return this.illegal("<head> has already been emitted.");
                }

                @Override
                State body() {
                    return SHOULD_CLOSE;
                }

                @Override
                State close() {
                    return CLOSED;
                }
            }
            ,
            SHOULD_CLOSE{

                @Override
                State head() {
                    return this.illegal("<head> and <body> have already been emitted.");
                }

                @Override
                State body() {
                    return this.illegal("<body> has already been emitted.");
                }

                @Override
                State close() {
                    return CLOSED;
                }
            }
            ,
            CLOSED{

                @Override
                State head() {
                    return this.illegal("Already closed");
                }

                @Override
                State body() {
                    return this.illegal("Already closed");
                }

                @Override
                State close() {
                    return this.illegal("Already closed");
                }
            };


            abstract State head();

            abstract State body();

            abstract State close();

            State illegal(String message) {
                throw new IllegalStateException(message);
            }
        }
    }

    public static interface Attribute
    extends Serializable {
        public String name();

        public String value();
    }
}

