/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ReturnProperties {
    public static final String NODE_TYPE = "node";
    public static final String RELATIONSHIP_TYPE = "relationship";
    public static final String ID = "_id";
    public static final String LABEL = "_label";
    public static final String TYPE = "_type";
    public static final String INV = "_inV";
    public static final String OUTV = "_outV";
    public static final List<String> ALL_PROPERTIES = Arrays.asList("_id", "_label", "_type", "_inV", "_outV");

    private ReturnProperties() {
    }

    public static boolean isNode(Object value) {
        return value instanceof Map && NODE_TYPE.equals(((Map)value).get(TYPE));
    }

    public static boolean isRelationship(Object value) {
        return value instanceof Map && RELATIONSHIP_TYPE.equals(((Map)value).get(TYPE));
    }

    public static boolean isPath(Object value) {
        if (!(value instanceof List)) {
            return false;
        }
        List list = (List)value;
        if (list.isEmpty() || !ReturnProperties.isNode(list.get(0))) {
            return false;
        }
        for (Object e : list) {
            if (ReturnProperties.isNode(e) || ReturnProperties.isRelationship(e)) continue;
            return false;
        }
        return true;
    }
}

