/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation.groovy;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencypher.gremlin.translation.groovy.Verbatim;

public final class StringTranslationUtils {
    private StringTranslationUtils() {
    }

    public static String apply(String name, Object ... arguments) {
        String joined = Stream.of(arguments).map(StringTranslationUtils::toLiteral).collect(Collectors.joining(", "));
        return name + "(" + joined + ")";
    }

    static String chain(String name, Object ... arguments) {
        return "." + StringTranslationUtils.apply(name, arguments);
    }

    public static String toLiteral(Object argument) {
        if (argument instanceof List) {
            return ((List)argument).stream().map(StringTranslationUtils::toLiteral).collect(Collectors.joining(", ", "[", "]"));
        }
        if (argument instanceof Map) {
            Map map = (Map)argument;
            if (map.isEmpty()) {
                return "[:]";
            }
            return map.entrySet().stream().map(entry -> {
                Object key = entry.getKey();
                String value = StringTranslationUtils.toLiteral(entry.getValue());
                return key + ": " + value;
            }).collect(Collectors.joining(", ", "[", "]"));
        }
        if (argument instanceof String) {
            return StringTranslationUtils.toStringLiteral((String)argument);
        }
        if (argument == null) {
            return "null";
        }
        if (argument instanceof Verbatim) {
            return ((Verbatim)argument).getValue();
        }
        return argument.toString();
    }

    private static String toStringLiteral(String agrument) {
        return "'" + agrument.replaceAll("(['\\\\])", "\\\\$1") + "'";
    }
}

