/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.IntegerType;
import org.opencypher.v9_0.util.symbols.ListType;
import org.opencypher.v9_0.util.symbols.NodeType;
import org.opencypher.v9_0.util.symbols.PathType;
import org.opencypher.v9_0.util.symbols.RelationshipType;

public final class ReturnNormalizer {
    private final Map<String, CypherType> variableTypes;

    private ReturnNormalizer(Map<String, CypherType> variableTypes) {
        this.variableTypes = variableTypes;
    }

    public static ReturnNormalizer create(Map<String, CypherType> variableTypes) {
        return new ReturnNormalizer(variableTypes);
    }

    public Map<String, Object> normalize(Object row) {
        if (row instanceof String) {
            throw new IllegalStateException("Invalid response: expected Map, got String. Probable cause: 'serializeResultToString' set to 'true' in Gremlin serializer config");
        }
        return (Map)this.normalizeValue(row);
    }

    private Object normalizeValue(Object value) {
        if (value instanceof Map) {
            return this.normalizeMap((Map)value);
        }
        if (value instanceof Collection) {
            return this.normalizeCollection((Collection)value);
        }
        if (value instanceof DetachedVertexProperty) {
            return this.elementPropertyMap((Element)((DetachedVertexProperty)value));
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if ("  cypher.null".equals(value)) {
            return null;
        }
        if (value instanceof Double && Double.isNaN((Double)value)) {
            return null;
        }
        if (value instanceof Traverser) {
            return this.normalize(((Traverser)value).get());
        }
        return value;
    }

    private Object normalizeValue(CypherType type, Object value) {
        if ("  cypher.null".equals(value)) {
            return null;
        }
        if (type instanceof NodeType) {
            return this.normalizeElement((Map)value, "node");
        }
        if (type instanceof RelationshipType) {
            return this.normalizeRelationship((Map)value);
        }
        if (type instanceof PathType) {
            return this.normalizePath((Map)value);
        }
        if (type instanceof IntegerType) {
            return this.normalizeInteger(value);
        }
        if (type instanceof ListType) {
            CypherType cypherType = ((ListType)type).innerType();
            return ((Collection)value).stream().map(v -> this.normalizeValue(cypherType, v)).collect(Collectors.toList());
        }
        return this.normalizeValue(value);
    }

    private Map<Object, Object> normalizeElement(Map<?, ?> value, String type) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put("_type", type);
        result.put("_id", this.getT(value, T.id));
        result.put("_label", this.getT(value, T.label));
        boolean gremlinTokensCanBeMapKeys = value.containsKey(T.id);
        value.entrySet().stream().filter(e1 -> this.isProperty((Map.Entry<?, ?>)e1, gremlinTokensCanBeMapKeys)).forEach(e -> {
            if ("node".equals(type) && this.isVertexValueList(e.getValue())) {
                result.put(e.getKey(), this.normalizeValue(((Collection)e.getValue()).iterator().next()));
            } else {
                result.put(e.getKey(), this.normalizeValue(e.getValue()));
            }
        });
        return result;
    }

    private Map<Object, Object> normalizeRelationship(Map<?, ?> value) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put("_type", "relationship");
        result.put("_inV", value.get("  cypher.inv"));
        result.put("_outV", value.get("  cypher.outv"));
        if (value.containsKey("  cypher.element")) {
            Map element = (Map)value.get("  cypher.element");
            result.put("_id", this.getT(element, T.id));
            result.put("_label", this.getT(element, T.label));
            boolean gremlinTokensCanBeMapKeys = element.containsKey(T.id);
            element.entrySet().stream().filter(e -> this.isProperty((Map.Entry<?, ?>)e, gremlinTokensCanBeMapKeys)).forEach(e -> result.put(e.getKey(), this.normalizeValue(e.getValue())));
        }
        return result;
    }

    private Object normalizePath(Map<?, ?> value) {
        List relationships = (List)value.get("  cypher.relationship");
        List elements = (List)value.get("  cypher.element");
        HashMap relationshipMap = new HashMap();
        for (Map relationship : relationships) {
            relationshipMap.put(relationship.get("  cypher.id"), relationship);
        }
        ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Map element;
            Object id = this.getT(element = (Map)iterator.next(), T.id);
            boolean isRelationship = relationshipMap.containsKey(id);
            Map<Object, Object> normalized = this.normalizeElement(element, isRelationship ? "relationship" : "node");
            if (isRelationship) {
                normalized.put("_inV", ((Map)relationshipMap.get(id)).get("  cypher.inv"));
                normalized.put("_outV", ((Map)relationshipMap.get(id)).get("  cypher.outv"));
            }
            result.add(normalized);
        }
        return result;
    }

    private Map<?, ?> normalizeMap(Map<?, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            String key = String.valueOf(e.getKey());
            Object value = this.variableTypes.containsKey(key) ? this.normalizeValue(this.variableTypes.get(key), e.getValue()) : this.normalizeValue(e.getValue());
            result.put(key, value);
        }
        return result;
    }

    Collection<?> normalizeCollection(Collection<?> value) {
        return value.stream().map(this::normalizeValue).collect(Collectors.toList());
    }

    private Object normalizeInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return value;
    }

    private Object elementPropertyMap(Element element) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Iterator properties = element.properties(new String[0]);
        while (properties.hasNext()) {
            Property next = (Property)properties.next();
            result.put(next.key(), next.value());
        }
        return result;
    }

    private Object getT(Map<?, ?> element, T prop) {
        return element.containsKey(prop) ? element.get(prop) : element.get(prop.toString());
    }

    private boolean isVertexValueList(Object e) {
        return e instanceof Collection && ((Collection)e).size() == 1;
    }

    private boolean isProperty(Map.Entry<?, ?> e, boolean gremlinTokensCanBeMapKeys) {
        if (gremlinTokensCanBeMapKeys) {
            return !T.id.equals(e.getKey()) && !T.label.equals(e.getKey());
        }
        return !("label".equals(e.getKey()) && !this.isVertexValueList(e.getValue()) || "id".equals(e.getKey()) && !this.isVertexValueList(e.getValue()));
    }
}

