/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation.translator;

import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.opencypher.gremlin.translation.GremlinBindings;
import org.opencypher.gremlin.translation.GremlinPredicates;
import org.opencypher.gremlin.translation.GremlinSteps;
import org.opencypher.gremlin.translation.groovy.GroovyGremlinBindings;
import org.opencypher.gremlin.translation.groovy.GroovyGremlinPredicates;
import org.opencypher.gremlin.translation.groovy.GroovyGremlinSteps;
import org.opencypher.gremlin.translation.groovy.GroovyPredicate;
import org.opencypher.gremlin.translation.translator.TranslatorFlavor;
import org.opencypher.gremlin.translation.traversal.TraversalGremlinBindings;
import org.opencypher.gremlin.translation.traversal.TraversalGremlinPredicates;
import org.opencypher.gremlin.translation.traversal.TraversalGremlinSteps;

public final class Translator<T, P> {
    private final GremlinSteps<T, P> steps;
    private final GremlinPredicates<P> predicates;
    private final GremlinBindings bindings;

    private Translator(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings bindings, TranslatorFlavor<T, P> flavor) {
        this.steps = flavor.decorateTranslationBuilder(steps);
        this.predicates = predicates;
        this.bindings = bindings;
    }

    public GremlinSteps<T, P> steps() {
        return this.steps;
    }

    public GremlinPredicates<P> predicates() {
        return this.predicates;
    }

    public GremlinBindings bindings() {
        return this.bindings;
    }

    public T translate() {
        return this.steps.current();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class GremlinGroovyFlavorBuilder
    extends FlavorBuilder<String, GroovyPredicate> {
        private GremlinGroovyFlavorBuilder(GremlinSteps<String, GroovyPredicate> steps, GremlinPredicates<GroovyPredicate> predicates, GremlinBindings bindings) {
            super(steps, predicates, bindings);
        }

        public FlavorBuilder<String, GroovyPredicate> inlineParameters() {
            this.bindings = new TraversalGremlinBindings();
            return this;
        }
    }

    public static class FlavorBuilder<T, P> {
        private final GremlinSteps<T, P> steps;
        private final GremlinPredicates<P> predicates;
        protected GremlinBindings bindings;

        private FlavorBuilder(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings bindings) {
            this.steps = steps;
            this.predicates = predicates;
            this.bindings = bindings;
        }

        public Translator<T, P> build() {
            return new Translator(this.steps, this.predicates, this.bindings, TranslatorFlavor.gremlinServer());
        }

        public Translator<T, P> build(TranslatorFlavor<T, P> flavor) {
            return new Translator(this.steps, this.predicates, this.bindings, flavor);
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public GremlinGroovyFlavorBuilder gremlinGroovy() {
            return new GremlinGroovyFlavorBuilder(new GroovyGremlinSteps(), new GroovyGremlinPredicates(), new GroovyGremlinBindings());
        }

        public FlavorBuilder<GraphTraversal, P> traversal() {
            return this.traversal((GraphTraversal)new DefaultGraphTraversal());
        }

        public FlavorBuilder<GraphTraversal, P> traversal(GraphTraversal g) {
            return new FlavorBuilder<GraphTraversal, P>(new TraversalGremlinSteps(g), new TraversalGremlinPredicates(), new TraversalGremlinBindings());
        }

        public <T, P> FlavorBuilder<T, P> custom(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings parameters) {
            return new FlavorBuilder(steps, predicates, parameters);
        }
    }
}

