/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.opencypher.gremlin.translation.exception.TypeException;

public class CustomFunction
implements Function<Traverser, Object> {
    private final String name;
    private final Object[] args;
    private final Function<Traverser, Object> implementation;

    private CustomFunction(String name, Function<Traverser, Object> reference, Object ... args) {
        this.name = name;
        this.args = args;
        this.implementation = reference;
    }

    public String getName() {
        return this.name;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public Object apply(Traverser traverser) {
        return this.implementation.apply(traverser);
    }

    public static CustomFunction length() {
        return new CustomFunction("length", traverser -> (((Path)traverser.get()).size() - 1) / 2, new Object[0]);
    }

    public static CustomFunction convertToString() {
        return new CustomFunction("convertToString", traverser -> Optional.ofNullable(traverser.get()).map(String::valueOf).orElse(null), new Object[0]);
    }

    public static CustomFunction convertToBoolean() {
        return new CustomFunction("convertToBoolean", traverser -> {
            boolean valid;
            Object arg = CustomFunction.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Boolean || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to boolean");
            }
            return Optional.ofNullable(arg).map(String::valueOf).map(v -> {
                switch (v.toLowerCase()) {
                    case "true": {
                        return Boolean.valueOf(true);
                    }
                    case "false": {
                        return Boolean.valueOf(false);
                    }
                }
                return "  cypher.null";
            }).orElse((Serializable)((Object)"  cypher.null"));
        }, new Object[0]);
    }

    public static CustomFunction convertToInteger() {
        return new CustomFunction("convertToInteger", traverser -> {
            boolean valid;
            Object arg = CustomFunction.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Number || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to integer");
            }
            return CustomFunction.nullToToken(Optional.ofNullable(arg).map(String::valueOf).map(v -> {
                try {
                    return Double.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).map(Double::intValue).orElse(null));
        }, new Object[0]);
    }

    public static CustomFunction convertToFloat() {
        return new CustomFunction("convertToFloat", traverser -> {
            boolean valid;
            Object arg = CustomFunction.tokenToNull(traverser.get());
            boolean bl = valid = arg == null || arg instanceof Number || arg instanceof String;
            if (!valid) {
                String className = arg.getClass().getName();
                throw new TypeException("Cannot convert " + className + " to float");
            }
            return CustomFunction.nullToToken(Optional.ofNullable(arg).map(String::valueOf).map(v -> {
                try {
                    return Double.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).orElse(null));
        }, new Object[0]);
    }

    public static CustomFunction nodes() {
        return new CustomFunction("nodes", traverser -> ((Path)traverser.get()).objects().stream().filter(element -> element instanceof Vertex).collect(Collectors.toList()), new Object[0]);
    }

    public static CustomFunction relationships() {
        return new CustomFunction("relationships", traverser -> ((Path)traverser.get()).objects().stream().flatMap(CustomFunction::flatten).filter(element -> element instanceof Edge).collect(Collectors.toList()), new Object[0]);
    }

    public static CustomFunction listComprehension(Object functionTraversal) {
        return new CustomFunction("listComprehension", traverser -> {
            Object list = traverser.get();
            if (!(list instanceof Collection)) {
                throw new IllegalArgumentException("Expected Iterable, got " + list.getClass());
            }
            if (!(functionTraversal instanceof GraphTraversal)) {
                throw new IllegalArgumentException("Expected GraphTraversal, got " + list.getClass());
            }
            return ((Collection)list).stream().map(item -> {
                GraphTraversal.Admin admin = ((GraphTraversal)GraphTraversal.class.cast(functionTraversal)).asAdmin();
                return TraversalUtil.apply((Object)item, (Traversal.Admin)admin);
            }).collect(Collectors.toList());
        }, functionTraversal);
    }

    public static CustomFunction pathComprehension() {
        return new CustomFunction("pathComprehension", arg -> ((Collection)arg.get()).stream().map(CustomFunction::pathToList).map(path -> {
            Optional<Object> first = ((Collection)path).stream().filter(Edge.class::isInstance).map(Edge.class::cast).findFirst();
            Edge edge = (Edge)first.orElseThrow(() -> new RuntimeException("Invalid path, no edge found!"));
            return Arrays.asList(edge.outVertex(), edge, edge.inVertex());
        }).collect(Collectors.toList()), new Object[0]);
    }

    public static CustomFunction containerIndex(Object index) {
        return new CustomFunction("containerIndex", traverser -> {
            Object arg = traverser.get();
            if (arg instanceof Map) {
                Map map = (Map)arg;
                return map.get(index);
            }
            Collection coll = (Collection)arg;
            int idx = Integer.parseInt(String.valueOf(index));
            return coll.stream().skip(idx).findFirst().orElse(null);
        }, index);
    }

    public static CustomFunction size() {
        return new CustomFunction("size", traverser -> traverser.get() instanceof String ? (long)((String)traverser.get()).length() : (long)((Collection)traverser.get()).size(), new Object[0]);
    }

    private static Object flatten(Object element) {
        return element instanceof Collection ? ((Collection)element).stream() : Stream.of(element);
    }

    private static Object tokenToNull(Object maybeNull) {
        return "  cypher.null".equals(maybeNull) ? null : maybeNull;
    }

    private static Object nullToToken(Object maybeNull) {
        return maybeNull == null ? "  cypher.null" : maybeNull;
    }

    public static Object pathToList(Object value) {
        return value instanceof Path ? new ArrayList(((Path)value).objects()) : value;
    }
}

