/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;

public final class ReturnNormalizer {
    private ReturnNormalizer() {
    }

    public static Map<String, Object> normalize(Object row) {
        return (Map)ReturnNormalizer.normalizeValue(row);
    }

    private static Object normalizeValue(Object value) {
        if (value instanceof Map) {
            return ReturnNormalizer.normalizeMap((Map)value);
        }
        if (value instanceof Collection) {
            return ReturnNormalizer.normalizeCollection((Collection)value);
        }
        if (value instanceof DetachedVertex) {
            return ReturnNormalizer.normalizeDetachedVertex((DetachedVertex)value);
        }
        if (value instanceof DetachedVertexProperty) {
            return ReturnNormalizer.elementPropertyMap((Element)((DetachedVertexProperty)value));
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if ("  cypher.null".equals(value)) {
            return null;
        }
        if (value instanceof Path) {
            return new ArrayList(((Path)value).objects());
        }
        if (value instanceof Traverser) {
            return ReturnNormalizer.normalize(((Traverser)value).get());
        }
        return value;
    }

    private static Map<?, ?> normalizeMap(Map<?, ?> value) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> e : value.entrySet()) {
            result.put(String.valueOf(e.getKey()), ReturnNormalizer.normalizeValue(e.getValue()));
        }
        return result;
    }

    private static Collection<?> normalizeCollection(Collection<?> value) {
        return value.stream().map(ReturnNormalizer::normalizeValue).collect(Collectors.toList());
    }

    private static DetachedVertex normalizeDetachedVertex(DetachedVertex vertex) {
        DetachedVertex.Builder builder = DetachedVertex.build().setId(vertex.id()).setLabel(vertex.label());
        Iterator properties = vertex.properties(new String[0]);
        while (properties.hasNext()) {
            VertexProperty property = (VertexProperty)properties.next();
            DetachedVertexProperty normalizedProperty = DetachedVertexProperty.build().setId(property.id()).setLabel(property.label()).setV(vertex).setValue(ReturnNormalizer.normalizeValue(property.value())).create();
            builder.addProperty(normalizedProperty);
        }
        return builder.create();
    }

    private static Object elementPropertyMap(Element element) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Iterator properties = element.properties(new String[0]);
        while (properties.hasNext()) {
            Property next = (Property)properties.next();
            result.put(next.key(), next.value());
        }
        return result;
    }
}

