/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation.traversal;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.opencypher.gremlin.translation.GremlinSteps;
import org.opencypher.gremlin.traversal.CustomFunction;

public class TraversalGremlinSteps
implements GremlinSteps<GraphTraversal, P> {
    private final GraphTraversal g;

    public TraversalGremlinSteps(GraphTraversal g) {
        this.g = g;
    }

    @Override
    public GraphTraversal current() {
        return this.g.asAdmin().clone();
    }

    private boolean isStartedOrSubTraversal() {
        boolean hasSteps = this.g.asAdmin().getSteps().size() > 0;
        boolean isSubTraversal = this.g.asAdmin().getGraph().filter(graph -> graph instanceof EmptyGraph).isPresent();
        return hasSteps || isSubTraversal;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> start() {
        GraphTraversal g = __.start();
        return new TraversalGremlinSteps(g);
    }

    @Override
    public GremlinSteps<GraphTraversal, P> V() {
        if (this.isStartedOrSubTraversal()) {
            this.g.V(new Object[0]);
        } else {
            this.g.asAdmin().getBytecode().addStep("V", new Object[0]);
            this.g.asAdmin().addStep((Step)new GraphStep((Traversal.Admin)this.g.asAdmin(), Vertex.class, true, new Object[0]));
        }
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> E() {
        if (this.isStartedOrSubTraversal()) {
            throw new IllegalStateException("Edge graph step can only be at the start of traversal");
        }
        this.g.asAdmin().getBytecode().addStep("E", new Object[0]);
        this.g.asAdmin().addStep((Step)new GraphStep((Traversal.Admin)this.g.asAdmin(), Edge.class, true, new Object[0]));
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> addE(String edgeLabel) {
        this.g.addE(edgeLabel);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> addV() {
        if (this.isStartedOrSubTraversal()) {
            this.g.addV();
        } else {
            this.g.asAdmin().getBytecode().addStep("addV", new Object[0]);
            this.g.asAdmin().addStep((Step)new AddVertexStartStep((Traversal.Admin)this.g.asAdmin(), (String)null));
        }
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> addV(String vertexLabel) {
        if (this.isStartedOrSubTraversal()) {
            this.g.addV(vertexLabel);
        } else {
            this.g.asAdmin().getBytecode().addStep("addV", new Object[]{vertexLabel});
            this.g.asAdmin().addStep((Step)new AddVertexStartStep((Traversal.Admin)this.g.asAdmin(), vertexLabel));
        }
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> aggregate(String sideEffectKey) {
        this.g.aggregate(sideEffectKey);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> and(GremlinSteps<GraphTraversal, P> ... andTraversals) {
        this.g.and((Traversal[])TraversalGremlinSteps.traversals(andTraversals));
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> as(String stepLabel) {
        this.g.as(stepLabel, new String[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> barrier() {
        this.g.barrier();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> bothE(String ... edgeLabels) {
        this.g.bothE(edgeLabels);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> by(GremlinSteps<GraphTraversal, P> traversal2, Order order2) {
        this.g.by((Traversal)traversal2.current(), (Comparator)order2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> by(GremlinSteps<GraphTraversal, P> traversal2) {
        this.g.by((Traversal)traversal2.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> cap(String sideEffectKey) {
        this.g.cap(sideEffectKey, new String[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> choose(GremlinSteps<GraphTraversal, P> choiceTraversal) {
        this.g.choose((Traversal)choiceTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> choose(GremlinSteps<GraphTraversal, P> traversalPredicate, GremlinSteps<GraphTraversal, P> trueChoice) {
        this.g.choose((Traversal)traversalPredicate.current(), (Traversal)trueChoice.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> choose(GremlinSteps<GraphTraversal, P> traversalPredicate, GremlinSteps<GraphTraversal, P> trueChoice, GremlinSteps<GraphTraversal, P> falseChoice) {
        this.g.choose((Traversal)traversalPredicate.current(), (Traversal)trueChoice.current(), (Traversal)falseChoice.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> choose(P predicate2, GremlinSteps<GraphTraversal, P> trueChoice, GremlinSteps<GraphTraversal, P> falseChoice) {
        this.g.choose((Predicate)predicate2, (Traversal)trueChoice.current(), (Traversal)falseChoice.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> choose(P predicate2, GremlinSteps<GraphTraversal, P> trueChoice) {
        this.g.choose((Predicate)predicate2, (Traversal)trueChoice.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> coalesce(GremlinSteps<GraphTraversal, P> ... coalesceTraversals) {
        this.g.coalesce((Traversal[])TraversalGremlinSteps.traversals(coalesceTraversals));
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> constant(Object e) {
        this.g.constant(e);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> count() {
        this.g.count();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> count(Scope scope2) {
        this.g.count(scope2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> dedup(String ... dedupLabels) {
        this.g.dedup(dedupLabels);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> drop() {
        this.g.drop();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> emit() {
        this.g.emit();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> emit(GremlinSteps<GraphTraversal, P> traversal2) {
        this.g.emit((Traversal)traversal2.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> flatMap(GremlinSteps<GraphTraversal, P> traversal2) {
        this.g.flatMap((Traversal)traversal2.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> fold() {
        this.g.fold();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> from(String fromStepLabel) {
        this.g.from(fromStepLabel);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> group() {
        this.g.group();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> has(String propertyKey) {
        this.g.has(propertyKey);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> has(String propertyKey, P predicate2) {
        this.g.has(propertyKey, predicate2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> hasKey(String ... labels) {
        if (labels.length >= 1) {
            this.g.hasKey(labels[0], TraversalGremlinSteps.argumentsSlice(labels, 1));
        }
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> hasLabel(String ... labels) {
        if (labels.length >= 1) {
            this.g.hasLabel(labels[0], TraversalGremlinSteps.argumentsSlice(labels, 1));
        }
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> hasNot(String propertyKey) {
        this.g.hasNot(propertyKey);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> id() {
        this.g.id();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> identity() {
        this.g.identity();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> inE(String ... edgeLabels) {
        this.g.inE(edgeLabels);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> inV() {
        this.g.inV();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> index() {
        this.g.index();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> inject(Object ... injections) {
        this.g.inject(injections);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> is(P predicate2) {
        this.g.is(predicate2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> key() {
        this.g.key();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> label() {
        this.g.label();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> limit(long limit2) {
        this.g.limit(limit2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> limit(Scope scope2, long limit2) {
        this.g.limit(scope2, limit2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> local(GremlinSteps<GraphTraversal, P> localTraversal) {
        this.g.local((Traversal)localTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> loops() {
        this.g.loops();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> map(CustomFunction function) {
        this.g.map(function.getImplementation());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> map(GremlinSteps<GraphTraversal, P> traversal2) {
        this.g.map((Traversal)traversal2.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> math(String expression) {
        this.g.math(expression);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> max() {
        this.g.max();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> max(Scope scope2) {
        this.g.max(scope2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> mean() {
        this.g.mean();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> mean(Scope scope2) {
        this.g.mean(scope2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> min() {
        this.g.min();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> min(Scope scope2) {
        this.g.min(scope2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> not(GremlinSteps<GraphTraversal, P> notTraversal) {
        this.g.not((Traversal)notTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> option(Object pickToken, GremlinSteps<GraphTraversal, P> traversalOption) {
        this.g.option(pickToken, (Traversal)traversalOption.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> optional(GremlinSteps<GraphTraversal, P> optionalTraversal) {
        this.g.optional((Traversal)optionalTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> or(GremlinSteps<GraphTraversal, P> ... orTraversals) {
        this.g.or((Traversal[])TraversalGremlinSteps.traversals(orTraversals));
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> order() {
        this.g.order();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> otherV() {
        this.g.otherV();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> outE(String ... edgeLabels) {
        this.g.outE(edgeLabels);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> outV() {
        this.g.outV();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> path() {
        this.g.path();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> properties(String ... propertyKeys) {
        this.g.properties(propertyKeys);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> property(T token, Object value2) {
        this.g.property((Object)token, value2, new Object[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> property(String key2, Object value2) {
        this.g.property((Object)key2, value2, new Object[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> property(VertexProperty.Cardinality cardinality2, String key2, Object value2) {
        this.g.property(cardinality2, (Object)key2, value2, new Object[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> property(String key2, GremlinSteps<GraphTraversal, P> traversal2) {
        return this.property(key2, (Object)traversal2.current());
    }

    @Override
    public GremlinSteps<GraphTraversal, P> property(VertexProperty.Cardinality cardinality2, String key2, GremlinSteps<GraphTraversal, P> traversal2) {
        this.g.property(cardinality2, (Object)key2, (Object)traversal2.current(), new Object[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> project(String ... keys) {
        if (keys.length < 1) {
            throw new IllegalArgumentException("`project()` step requires keys");
        }
        this.g.project(keys[0], TraversalGremlinSteps.argumentsSlice(keys, 1));
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> range(Scope scope2, long low, long high) {
        this.g.range(scope2, low, high);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> repeat(GremlinSteps<GraphTraversal, P> repeatTraversal) {
        this.g.repeat((Traversal)repeatTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> select(Pop pop, String selectKey) {
        this.g.select(pop, selectKey);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> select(String ... selectKeys) {
        if (selectKeys.length >= 2) {
            this.g.select(selectKeys[0], selectKeys[1], TraversalGremlinSteps.argumentsSlice(selectKeys, 2));
        } else if (selectKeys.length == 1) {
            this.g.select(selectKeys[0]);
        } else {
            throw new IllegalArgumentException("Select step should have arguments");
        }
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> select(Column column2) {
        this.g.select(column2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> sideEffect(GremlinSteps<GraphTraversal, P> sideEffectTraversal) {
        this.g.sideEffect((Traversal)sideEffectTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> simplePath() {
        this.g.simplePath();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> skip(long skip) {
        this.g.skip(skip);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> sum() {
        this.g.sum();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> sum(Scope scope2) {
        this.g.sum(scope2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> tail(Scope scope2, long limit2) {
        this.g.tail(scope2, limit2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> times(int maxLoops) {
        this.g.times(maxLoops);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> to(String toStepLabel) {
        this.g.to(toStepLabel);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> unfold() {
        this.g.unfold();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> union(GremlinSteps<GraphTraversal, P> ... unionTraversals) {
        this.g.union((Traversal[])TraversalGremlinSteps.traversals(unionTraversals));
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> until(GremlinSteps<GraphTraversal, P> untilTraversal) {
        this.g.until((Traversal)untilTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> valueMap() {
        this.g.valueMap(new String[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> valueMap(boolean includeTokens) {
        this.g.valueMap(includeTokens, new String[0]);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> value() {
        this.g.value();
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> values(String ... propertyKeys) {
        this.g.values(propertyKeys);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> where(GremlinSteps<GraphTraversal, P> whereTraversal) {
        this.g.where((Traversal)whereTraversal.current());
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> where(P predicate2) {
        this.g.where(predicate2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> with(String key2) {
        this.g.with(key2);
        return this;
    }

    @Override
    public GremlinSteps<GraphTraversal, P> with(String name, Object value2) {
        this.g.with(name, value2);
        return this;
    }

    private static String[] argumentsSlice(String[] arguments, int start) {
        String[] dest = new String[arguments.length - start];
        System.arraycopy(arguments, start, dest, 0, arguments.length - start);
        return dest;
    }

    private static GraphTraversal[] traversals(GremlinSteps<GraphTraversal, P>[] gremlinSteps) {
        return (GraphTraversal[])Stream.of(gremlinSteps).map(GremlinSteps::current).toArray(GraphTraversal[]::new);
    }

    public String toString() {
        return this.g.asAdmin().getBytecode().toString();
    }
}

