/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation.walker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.opencypher.gremlin.translation.GremlinPredicates;
import org.opencypher.gremlin.translation.GremlinSteps;
import org.opencypher.gremlin.translation.context.WalkerContext;
import org.opencypher.gremlin.translation.exception.CypherExceptions;
import org.opencypher.gremlin.translation.walker.ExpressionWalker$;
import org.opencypher.gremlin.traversal.CustomFunction;
import org.opencypher.v9_0.expressions.AnonymousPatternPart;
import org.opencypher.v9_0.expressions.DecimalDoubleLiteral;
import org.opencypher.v9_0.expressions.EveryPath;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.False;
import org.opencypher.v9_0.expressions.FunctionInvocation;
import org.opencypher.v9_0.expressions.ListComprehension;
import org.opencypher.v9_0.expressions.ListLiteral;
import org.opencypher.v9_0.expressions.Literal;
import org.opencypher.v9_0.expressions.LogicalVariable;
import org.opencypher.v9_0.expressions.LogicalVariable$;
import org.opencypher.v9_0.expressions.MapExpression;
import org.opencypher.v9_0.expressions.NamedPatternPart;
import org.opencypher.v9_0.expressions.NodePattern;
import org.opencypher.v9_0.expressions.Null;
import org.opencypher.v9_0.expressions.Parameter;
import org.opencypher.v9_0.expressions.PatternElement;
import org.opencypher.v9_0.expressions.PatternPart;
import org.opencypher.v9_0.expressions.RelationshipChain;
import org.opencypher.v9_0.expressions.RelationshipPattern;
import org.opencypher.v9_0.expressions.SignedDecimalIntegerLiteral;
import org.opencypher.v9_0.expressions.StringLiteral;
import org.opencypher.v9_0.expressions.True;
import org.opencypher.v9_0.expressions.Variable;
import org.opencypher.v9_0.util.ASTNode;
import org.opencypher.v9_0.util.InputPosition$;
import org.opencypher.v9_0.util.symbols.AnyType;
import org.opencypher.v9_0.util.symbols.AnyType$;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.ListType;
import org.opencypher.v9_0.util.symbols.NodeType;
import org.opencypher.v9_0.util.symbols.RelationshipType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NodeUtils$ {
    public static final NodeUtils$ MODULE$;

    static {
        new NodeUtils$();
    }

    public <T, P> Object expressionValue(Expression node, WalkerContext<T, P> context) {
        return this.traversalValueToJava(node, context, (Function1<String, Object>)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final WalkerContext context$3;

            public final Object apply(String name) {
                return this.context$3.parameter(name);
            }
            {
                this.context$3 = context$3;
            }
        });
    }

    public <T, P> Object inlineExpressionValue(Expression node, WalkerContext<T, P> context) {
        return this.inlineExpressionValue(node, context, Object.class);
    }

    public <T, P, R> R inlineExpressionValue(Expression node, WalkerContext<T, P> context, Class<R> klass) {
        Serializable parameterHandler = new Serializable(context, klass){
            public static final long serialVersionUID = 0L;
            private final WalkerContext context$5;
            private final Class klass$1;

            public final R apply(String name) {
                return this.context$5.inlineParameter(name, this.klass$1);
            }
            {
                this.context$5 = context$5;
                this.klass$1 = klass$1;
            }
        };
        return (R)this.traversalValueToJava(node, context, (Function1<String, Object>)parameterHandler);
    }

    public <T, P> Object traversalValueToJava(Object value2, WalkerContext<T, P> context, Function1<String, Object> parameterHandler) {
        Option<Object> option2 = this.traversalValueOption(value2, context, parameterHandler);
        if (option2 instanceof Some) {
            Object javaValue;
            Some some = (Some)option2;
            Object object = javaValue = some.x();
            return object;
        }
        if (None$.MODULE$.equals(option2)) {
            throw context.unsupported("value expression", value2);
        }
        throw new MatchError(option2);
    }

    public <T, P> Option<Object> traversalValueOption(Object value2, WalkerContext<T, P> context, Function1<String, Object> parameterHandler) {
        FunctionInvocation functionInvocation;
        IndexedSeq indexedSeq;
        Some some;
        ListComprehension listComprehension;
        Expression expression;
        Some some2;
        Object object = value2;
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            String varName = variable.name();
            some2 = new Some((Object)varName);
        } else if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            String name = parameter.name();
            some2 = new Some(parameterHandler.apply((Object)name));
        } else if (object instanceof Null) {
            some2 = new Some((Object)"  cypher.null");
        } else if (object instanceof ListComprehension && (expression = (listComprehension = (ListComprehension)object).expression()) instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            String name = parameter.name();
            some2 = new Some(parameterHandler.apply((Object)name));
        } else if (object instanceof Literal) {
            Literal literal = (Literal)object;
            some2 = new Some(literal.value());
        } else if (object instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)object;
            Seq expressions = listLiteral.expressions();
            some2 = new Some(this.traversalValueToJava(expressions, context, parameterHandler));
        } else if (object instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)object;
            Seq items = mapExpression.items();
            some2 = new Some(this.traversalValueToJava(items.toMap(Predef$.MODULE$.$conforms()), context, parameterHandler));
        } else if (object instanceof FunctionInvocation && !(some = Seq$.MODULE$.unapplySeq((Seq)(indexedSeq = (functionInvocation = (FunctionInvocation)object).args()))).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            Expression args = (Expression)((SeqLike)some.get()).apply(0);
            some2 = new Some(this.expressionValue(args, context));
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            Seq mappedSeq = (Seq)seq.map((Function1)new Serializable(context, parameterHandler){
                public static final long serialVersionUID = 0L;
                private final WalkerContext context$4;
                private final Function1 parameterHandler$1;

                public final Object apply(Object x$1) {
                    return NodeUtils$.MODULE$.traversalValueToJava(x$1, this.context$4, (Function1<String, Object>)this.parameterHandler$1);
                }
                {
                    this.context$4 = context$4;
                    this.parameterHandler$1 = parameterHandler$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            some2 = new Some(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(mappedSeq).asJava()));
        } else if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            scala.collection.immutable.Map mappedMap = map.mapValues((Function1)new Serializable(context, parameterHandler){
                public static final long serialVersionUID = 0L;
                private final WalkerContext context$4;
                private final Function1 parameterHandler$1;

                public final Object apply(Object x$2) {
                    return NodeUtils$.MODULE$.traversalValueToJava(x$2, this.context$4, (Function1<String, Object>)this.parameterHandler$1);
                }
                {
                    this.context$4 = context$4;
                    this.parameterHandler$1 = parameterHandler$1;
                }
            });
            some2 = new Some(new LinkedHashMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)mappedMap).asJava()));
        } else {
            some2 = None$.MODULE$;
        }
        return some2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector<String> getPathTraversalAliases(PatternPart patternPart) {
        PatternPart patternPart2 = patternPart;
        if (!(patternPart2 instanceof NamedPatternPart)) return this.getPathTraversalAliases(patternPart.element());
        NamedPatternPart namedPatternPart = (NamedPatternPart)patternPart2;
        Variable variable = namedPatternPart.variable();
        AnonymousPatternPart anonymousPatternPart = namedPatternPart.patternPart();
        if (variable == null) return this.getPathTraversalAliases(patternPart.element());
        String pathName = variable.name();
        if (!(anonymousPatternPart instanceof EveryPath)) return this.getPathTraversalAliases(patternPart.element());
        EveryPath everyPath = (EveryPath)anonymousPatternPart;
        PatternElement patternElement = everyPath.element();
        return (Vector)this.getPathTraversalAliases(patternElement).$colon$plus((Object)pathName, Vector$.MODULE$.canBuildFrom());
    }

    public Vector<String> getPathTraversalAliases(PatternElement patternElement) {
        return (Vector)this.flattenRelationshipChain((ASTNode)patternElement).foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector<String> apply(Vector<String> acc, ASTNode element) {
                Some some;
                LogicalVariable logicalVariable;
                RelationshipPattern relationshipPattern;
                Option option2;
                Vector vector;
                Some some2;
                LogicalVariable logicalVariable2;
                NodePattern nodePattern;
                Option option3;
                ASTNode aSTNode = element;
                if (aSTNode instanceof NodePattern && (option3 = (nodePattern = (NodePattern)aSTNode).variable()) instanceof Some && (logicalVariable2 = (LogicalVariable)(some2 = (Some)option3).x()) instanceof Variable) {
                    Variable variable = (Variable)logicalVariable2;
                    String name = variable.name();
                    vector = (Vector)acc.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom());
                } else if (aSTNode instanceof RelationshipPattern && (option2 = (relationshipPattern = (RelationshipPattern)aSTNode).variable()) instanceof Some && (logicalVariable = (LogicalVariable)(some = (Some)option2).x()) instanceof Variable) {
                    Variable variable = (Variable)logicalVariable;
                    String name = variable.name();
                    vector = (Vector)acc.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom());
                } else {
                    vector = acc;
                }
                return vector;
            }
        });
    }

    public Vector<ASTNode> flattenRelationshipChain(ASTNode node) {
        return this.flattenRelationshipChain((Vector<ASTNode>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), node);
    }

    private Vector<ASTNode> flattenRelationshipChain(Vector<ASTNode> acc, ASTNode node) {
        Vector vector;
        ASTNode aSTNode = node;
        if (aSTNode instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)aSTNode;
            PatternElement left = relationshipChain.element();
            RelationshipPattern relationship = relationshipChain.relationship();
            NodePattern right = relationshipChain.rightNode();
            vector = (Vector)((Vector)((Vector)acc.$plus$plus(this.flattenRelationshipChain((Vector<ASTNode>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), (ASTNode)left), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelationshipPattern[]{relationship})), Vector$.MODULE$.canBuildFrom())).$plus$plus(this.flattenRelationshipChain((Vector<ASTNode>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), (ASTNode)right), Vector$.MODULE$.canBuildFrom());
        } else {
            vector = (Vector)acc.$colon$plus((Object)aSTNode, Vector$.MODULE$.canBuildFrom());
        }
        return vector;
    }

    public <T, P> GremlinSteps<T, P> asUniqueName(String name, GremlinSteps<T, P> g, WalkerContext<T, P> context) {
        GremlinSteps<T, Object> gremlinSteps;
        GremlinPredicates<P> p = context.dsl().predicates();
        Option<String> option2 = context.alias(name);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String generated = (String)some.x();
            gremlinSteps = g.as(generated).where(g.start().select(generated).where(p.isEq(name)));
        } else {
            gremlinSteps = g.as(name);
        }
        return gremlinSteps;
    }

    public <T, P> GremlinSteps<T, P> notNull(GremlinSteps<T, P> traversal2, WalkerContext<T, P> context) {
        GremlinSteps<T, P> g = context.dsl().steps();
        GremlinPredicates<P> p = context.dsl().predicates();
        return g.start().choose(p.neq("  cypher.null"), traversal2);
    }

    public <T, P> GremlinSteps<T, P> emptyToNull(GremlinSteps<T, P> traversal2, WalkerContext<T, P> context) {
        GremlinSteps<T, P> g = context.dsl().steps();
        return g.start().choose(traversal2, (GremlinSteps<T, GremlinSteps<T, P>>)traversal2, (GremlinSteps<T, GremlinSteps<T, P>>)g.start().constant("  cypher.null"));
    }

    public <T, P> GremlinSteps<T, P> asList(Seq<Expression> expressions, WalkerContext<T, P> context) {
        GremlinSteps<T, P> g = context.dsl().steps();
        if (expressions.isEmpty()) {
            return g.start().constant(new ArrayList());
        }
        Seq keys = (Seq)expressions.map((Function1)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final WalkerContext context$1;

            public final String apply(Expression x$3) {
                return this.context$1.generateName();
            }
            {
                this.context$1 = context$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        GremlinSteps<T, P> traversal2 = g.start().project((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class)));
        ((IterableLike)expressions.map((Function1)new Serializable(context, g){
            public static final long serialVersionUID = 0L;
            private final WalkerContext context$1;
            private final GremlinSteps g$1;

            public final GremlinSteps<T, P> apply(Expression x$4) {
                return ExpressionWalker$.MODULE$.walkLocal(this.context$1, this.g$1, x$4, ExpressionWalker$.MODULE$.walkLocal$default$4());
            }
            {
                this.context$1 = context$1;
                this.g$1 = g$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(traversal2){
            public static final long serialVersionUID = 0L;
            private final GremlinSteps traversal$1;

            public final GremlinSteps<T, P> apply(GremlinSteps<T, P> traversal2) {
                return this.traversal$1.by(traversal2);
            }
            {
                this.traversal$1 = traversal$1;
            }
        });
        return traversal2.select(Column.values);
    }

    public <T, P> void ensureFirstStatement(GremlinSteps<T, P> traversal2, WalkerContext<T, P> context) {
        if (context.isFirstStatement()) {
            traversal2.inject("  cypher.start");
            context.markFirstStatement();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T, P> GremlinSteps<T, P> selectNestedAliases(Seq<String> keys, WalkerContext<T, P> context) {
        void var3_3;
        GremlinSteps<T, P> g = context.dsl().steps().start();
        String mapName = context.generateName();
        g.as(mapName);
        ((TraversableLike)keys.filter((Function1)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final WalkerContext context$6;

            public final boolean apply(String x$5) {
                return this.context$6.alias(x$5).isEmpty();
            }
            {
                this.context$6 = context$6;
            }
        })).map((Function1)new Serializable(g, mapName){
            public static final long serialVersionUID = 0L;
            private final GremlinSteps g$2;
            private final String mapName$1;

            public final GremlinSteps<T, P> apply(String alias2) {
                return this.g$2.select(this.mapName$1).select(alias2).as(alias2);
            }
            {
                this.g$2 = g$2;
                this.mapName$1 = mapName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public <T, P> GremlinSteps<T, P> reselectProjection(Seq<LogicalVariable> items, WalkerContext<T, P> context) {
        void var3_3;
        GremlinSteps<T, P> traversal2 = context.dsl().steps().start();
        String name = context.generateName();
        Object object = items.lengthCompare(1) > 0 ? traversal2.as(name) : BoxedUnit.UNIT;
        ((Stream)items.toStream().zipWithIndex(Stream$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(context, traversal2, name){
            public static final long serialVersionUID = 0L;
            private final WalkerContext context$2;
            private final GremlinSteps traversal$2;
            private final String name$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<LogicalVariable, Object> x0$1) {
                Tuple2<LogicalVariable, Object> tuple2 = x0$1;
                if (tuple2 == null) return BoxedUnit.UNIT;
                LogicalVariable logicalVariable = (LogicalVariable)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (!(logicalVariable instanceof Variable)) return BoxedUnit.UNIT;
                Variable variable = (Variable)logicalVariable;
                Option option2 = LogicalVariable$.MODULE$.unapply(variable);
                if (option2.isEmpty()) return BoxedUnit.UNIT;
                String alias2 = (String)option2.get();
                Object object = i > 0 ? this.traversal$2.select(this.name$1) : BoxedUnit.UNIT;
                this.traversal$2.select(alias2).as(alias2);
                return this.context$2.alias(alias2);
            }
            {
                this.context$2 = context$2;
                this.traversal$2 = traversal$2;
                this.name$1 = name$1;
            }
        });
        return var3_3;
    }

    public <T, P> GremlinSteps<T, P> setProperty(GremlinSteps<T, P> traversal2, CypherType cypherType, String key2, GremlinSteps<T, P> value2) {
        block4: {
            GremlinSteps<T, P> gremlinSteps;
            block3: {
                CypherType cypherType2;
                block2: {
                    cypherType2 = cypherType;
                    if (!(cypherType2 instanceof NodeType)) break block2;
                    gremlinSteps = traversal2.property(VertexProperty.Cardinality.single, key2, value2);
                    break block3;
                }
                if (!(cypherType2 instanceof RelationshipType)) break block4;
                gremlinSteps = traversal2.property(key2, value2);
            }
            return gremlinSteps;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported property type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cypherType})));
    }

    public Literal toLiteral(Object obj) {
        Object object;
        block8: {
            SignedDecimalIntegerLiteral signedDecimalIntegerLiteral;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    object = obj;
                                    boolean bl = object instanceof Integer ? true : object instanceof Long;
                                    if (!bl) break block2;
                                    signedDecimalIntegerLiteral = new SignedDecimalIntegerLiteral(String.valueOf(obj), InputPosition$.MODULE$.NONE());
                                    break block3;
                                }
                                if (!(object instanceof Double)) break block4;
                                Double d = (Double)object;
                                signedDecimalIntegerLiteral = new DecimalDoubleLiteral(String.valueOf(d), InputPosition$.MODULE$.NONE());
                                break block3;
                            }
                            if (!(object instanceof String)) break block5;
                            String string2 = (String)object;
                            signedDecimalIntegerLiteral = new StringLiteral(string2, InputPosition$.MODULE$.NONE());
                            break block3;
                        }
                        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)object)) break block6;
                        signedDecimalIntegerLiteral = new True(InputPosition$.MODULE$.NONE());
                        break block3;
                    }
                    if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)object)) break block7;
                    signedDecimalIntegerLiteral = new False(InputPosition$.MODULE$.NONE());
                    break block3;
                }
                if (object != null) break block8;
                signedDecimalIntegerLiteral = new Null(InputPosition$.MODULE$.NONE());
            }
            return signedDecimalIntegerLiteral;
        }
        throw new MatchError(object);
    }

    public <T, P> GremlinSteps<T, P> runtimeValidation(GremlinSteps<T, P> throwIfTrue, CypherExceptions exception, WalkerContext<T, P> context) {
        return context.dsl().steps().start().sideEffect(throwIfTrue.constant(exception.toString()).map(CustomFunction.cypherException()));
    }

    public <T, P> boolean isElement(Expression expression, WalkerContext<T, P> context) {
        return context.expressionTypes().get((Object)expression).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CypherType x0$2) {
                CypherType cypherType = x0$2;
                boolean bl = cypherType instanceof NodeType ? true : cypherType instanceof RelationshipType;
                boolean bl2 = bl;
                return bl2;
            }
        });
    }

    public <T, P> Seq<CypherType> qualifiedType(Expression expression, WalkerContext<T, P> context) {
        Seq seq;
        Option option2 = context.expressionTypes().get((Object)expression);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            CypherType typ = (CypherType)some.x();
            seq = this.extractTyp$1(typ);
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyType[]{AnyType$.MODULE$.instance()}));
        }
        return seq;
    }

    private final Seq extractTyp$1(CypherType typ) {
        List list;
        CypherType cypherType = typ;
        if (cypherType instanceof ListType) {
            ListType listType;
            ListType listType2 = listType = (ListType)cypherType;
            list = (Seq)this.extractTyp$1(listType.innerType()).$plus$colon((Object)listType2, Seq$.MODULE$.canBuildFrom());
        } else {
            CypherType cypherType2 = typ;
            list = Nil$.MODULE$.$colon$colon((Object)cypherType2);
        }
        return list;
    }

    private NodeUtils$() {
        MODULE$ = this;
    }
}

