/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ParameterNormalizer {
    private ParameterNormalizer() {
    }

    public static Map<String, Object> normalize(Map<String, ?> parameters) {
        return ParameterNormalizer.normalizeMap(parameters);
    }

    private static Object normalizeValue(Object value2) {
        if (value2 instanceof Map) {
            return ParameterNormalizer.normalizeMap((Map)value2);
        }
        if (value2 instanceof List) {
            return ParameterNormalizer.normalizeList((List)value2);
        }
        if (value2 instanceof Integer) {
            return ((Integer)value2).longValue();
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).doubleValue();
        }
        if (value2 == null) {
            return "  cypher.null";
        }
        return value2;
    }

    private static Map<String, Object> normalizeMap(Map<?, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            String key2 = String.valueOf(e.getKey());
            Object value2 = ParameterNormalizer.normalizeValue(e.getValue());
            result.put(key2, value2);
        }
        return result;
    }

    private static List<Object> normalizeList(List<?> list) {
        return list.stream().map(ParameterNormalizer::normalizeValue).collect(Collectors.toList());
    }
}

