/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class GroovyIdentifiers {
    private static final Set<String> GROOVY_KEYWORDS = new HashSet<String>(Arrays.asList("as", "assert", "break", "case", "catch", "class", "const", "continue", "def", "default", "do", "else", "enum", "extends", "false", "finally", "for", "goto", "if", "implements", "import", "in", "instanceof", "interface", "new", "null", "package", "return", "super", "switch", "this", "throw", "throws", "trait", "true", "try", "while"));

    private GroovyIdentifiers() {
    }

    public static boolean isValidIdentifier(String value) {
        char[] chars = value.toCharArray();
        int length = chars.length;
        if (length == 0) {
            return false;
        }
        if (!GroovyIdentifiers.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return !GROOVY_KEYWORDS.contains(value);
    }

    private static boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c) && Character.getType(c) != 26;
    }
}

