/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opencypher.gremlin.extension.CypherBinding;
import org.opencypher.gremlin.extension.CypherBindingType;
import org.opencypher.gremlin.extension.CypherProcedure;
import org.opencypher.gremlin.extension.CypherProcedureDefinition;
import org.opencypher.gremlin.extension.CypherProcedureSignature;
import org.opencypher.gremlin.traversal.CustomFunction;
import org.opencypher.gremlin.traversal.ReturnNormalizer;

public final class ProcedureContext {
    private final Map<String, CypherProcedureSignature> signatures = new HashMap<String, CypherProcedureSignature>();
    private final Map<String, CypherProcedure> implementations = new HashMap<String, CypherProcedure>();
    private final ReturnNormalizer returnNormalizer = ReturnNormalizer.create(Collections.emptyMap());

    public static ProcedureContext global() {
        return LazyHolder.GLOBAL;
    }

    public static ProcedureContext empty() {
        return new ProcedureContext();
    }

    public ProcedureContext() {
    }

    public ProcedureContext(CypherProcedureDefinition definition) {
        this.signatures.putAll(definition.getSignatures());
        this.implementations.putAll(definition.getImplementations());
    }

    public Map<String, CypherProcedureSignature> getSignatures() {
        return this.signatures;
    }

    public CypherProcedureSignature findOrThrow(String name) {
        CypherProcedureSignature signature = this.signatures.get(name);
        if (signature == null) {
            throw new IllegalArgumentException("Procedure not found: " + name);
        }
        return signature;
    }

    private CypherProcedure findImplementationOrThrow(String name) {
        CypherProcedure implementation = this.implementations.get(name);
        if (implementation == null) {
            throw new IllegalArgumentException("Procedure implementation not found: " + name);
        }
        return implementation;
    }

    void unsafeClear() {
        this.signatures.clear();
        this.implementations.clear();
    }

    void unsafeRegister(String name, List<CypherBinding> arguments, List<CypherBinding> results, CypherProcedure implementation) {
        this.signatures.put(name, new CypherProcedureSignature(arguments, results));
        this.implementations.put(name, implementation);
    }

    public CustomFunction procedureCall(String name) {
        return new CustomFunction("procedureCall", traverser -> {
            Collection arguments = (Collection)traverser.get();
            return this.call(name, arguments);
        });
    }

    private Object call(String name, Collection<?> arguments) {
        int callArgsSize;
        CypherProcedureSignature signature = this.findOrThrow(name);
        Object[] args = this.returnNormalizer.normalizeCollection(arguments).toArray();
        List<CypherBinding> defArgs = signature.getArguments();
        List<Object> callArgs = Arrays.asList(args);
        List defArgTypes = defArgs.stream().map(CypherBinding::getType).map(type -> CypherBindingType.NUMBER.isAssignableFrom((CypherBindingType)((Object)type)) ? CypherBindingType.NUMBER : type).map(CypherBindingType::getJavaClass).collect(Collectors.toList());
        ArrayList<Class> callArgTypes = new ArrayList<Class>();
        for (int i = 0; i < callArgs.size(); ++i) {
            Object arg = callArgs.get(i);
            Class type2 = arg != null ? arg.getClass() : (Class)defArgTypes.get(i);
            type2 = Number.class.isAssignableFrom(type2) ? Number.class : type2;
            callArgTypes.add(type2);
        }
        int defArgsSize = defArgTypes.size();
        if (defArgsSize != (callArgsSize = callArgTypes.size())) {
            throw new IllegalArgumentException("Invalid number of arguments for " + name + ": " + defArgsSize + " expected, but " + callArgsSize + " provided");
        }
        if (!defArgTypes.equals(callArgTypes)) {
            throw new IllegalArgumentException("Invalid argument types for " + name + ": " + defArgTypes + " expected, but " + callArgTypes + " provided");
        }
        CypherProcedure procedure = this.findImplementationOrThrow(name);
        HashMap<String, Object> implArgs = new HashMap<String, Object>();
        for (int i = 0; i < defArgsSize; ++i) {
            String argName = defArgs.get(i).getName();
            CypherBindingType argType = defArgs.get(i).getType();
            Object argValue = ProcedureContext.numericCast(callArgs.get(i), argType);
            implArgs.put(argName, argValue);
        }
        List<Map<String, Object>> rows = procedure.call(implArgs);
        List<CypherBinding> defResults = signature.getResults();
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rows) {
            LinkedHashMap<String, Object> orderedRow = new LinkedHashMap<String, Object>();
            for (CypherBinding res : defResults) {
                String resName = res.getName();
                CypherBindingType resType = res.getType();
                Object resValue = ProcedureContext.numericCast(row.get(resName), resType);
                orderedRow.put(resName, resValue);
            }
            results.add(this.returnNormalizer.normalize(orderedRow));
        }
        return results;
    }

    private static Object numericCast(Object value, CypherBindingType type) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (type.equals((Object)CypherBindingType.INTEGER)) {
                return number.longValue();
            }
            if (type.equals((Object)CypherBindingType.FLOAT)) {
                return number.doubleValue();
            }
        }
        return value;
    }

    private static final class LazyHolder {
        private static final ProcedureContext GLOBAL = ProcedureContext.empty();

        private LazyHolder() {
        }
    }
}

