/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.okapi.ir.api.expr;

import java.io.Serializable;
import org.opencypher.okapi.api.types.CTDate$;
import org.opencypher.okapi.api.types.CTDuration$;
import org.opencypher.okapi.api.types.CTInteger$;
import org.opencypher.okapi.api.types.CTList;
import org.opencypher.okapi.api.types.CTLocalDateTime$;
import org.opencypher.okapi.api.types.CTMap;
import org.opencypher.okapi.api.types.CTNode$;
import org.opencypher.okapi.api.types.CTNull$;
import org.opencypher.okapi.api.types.CTRelationship$;
import org.opencypher.okapi.api.types.CTString$;
import org.opencypher.okapi.api.types.CTUnion$;
import org.opencypher.okapi.api.types.CTVoid$;
import org.opencypher.okapi.api.types.CypherType;
import org.opencypher.okapi.api.types.package$;
import org.opencypher.okapi.impl.exception.NoSuitableSignatureForExpr;
import org.opencypher.okapi.ir.api.expr.Avg;
import org.opencypher.okapi.ir.api.expr.Coalesce;
import org.opencypher.okapi.ir.api.expr.Date;
import org.opencypher.okapi.ir.api.expr.Duration;
import org.opencypher.okapi.ir.api.expr.Explode;
import org.opencypher.okapi.ir.api.expr.Expr;
import org.opencypher.okapi.ir.api.expr.ListLit;
import org.opencypher.okapi.ir.api.expr.ListSegment;
import org.opencypher.okapi.ir.api.expr.LocalDateTime;
import org.opencypher.okapi.ir.api.expr.MapExpression;
import org.opencypher.okapi.ir.api.expr.Param;
import org.opencypher.okapi.ir.api.expr.Range;
import org.opencypher.okapi.ir.api.expr.Size;
import org.opencypher.okapi.ir.api.expr.StartNode;
import org.opencypher.okapi.ir.api.expr.Sum;
import org.opencypher.okapi.ir.api.expr.Trim;
import org.opencypher.okapi.ir.api.expr.Var;
import org.opencypher.okapi.ir.api.expr.Var$;
import org.opencypher.okapi.testing.BaseTestSuite;
import org.opencypher.okapi.testing.MatchHelper;
import org.opencypher.okapi.trees.AbstractTreeNode;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.matchers.Matcher;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\tAQ\t\u001f9s)\u0016\u001cHO\u0003\u0002\u0005\u000b\u0005!Q\r\u001f9s\u0015\t1q!A\u0002ba&T!\u0001C\u0005\u0002\u0005%\u0014(B\u0001\u0006\f\u0003\u0015y7.\u00199j\u0015\taQ\"\u0001\u0006pa\u0016t7-\u001f9iKJT\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ!\u0001F\u0005\u0002\u000fQ,7\u000f^5oO&\u0011ac\u0005\u0002\u000e\u0005\u0006\u001cX\rV3tiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0019\u0001")
public class ExprTest
extends BaseTestSuite {
    public ExprTest() {
        this.test("expressions ignore cypher type in equality", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Var n = Var$.MODULE$.apply("a", (CypherType)CTInteger$.MODULE$);
            Var r = Var$.MODULE$.apply("a", (CypherType)CTString$.MODULE$);
            this.convertToAnyShouldWrapper(n, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default()).should(this.equal(r), (Object)Equality$.MODULE$.default());
            StartNode a = new StartNode((Expr)Var$.MODULE$.apply("rel", (CypherType)CTRelationship$.MODULE$), (CypherType)package$.MODULE$.CTAny());
            StartNode b = new StartNode((Expr)Var$.MODULE$.apply("rel", (CypherType)CTRelationship$.MODULE$), (CypherType)CTNode$.MODULE$);
            return this.convertToAnyShouldWrapper(a, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).should(this.equal(b), (Object)Equality$.MODULE$.default());
        }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("same expressions with different cypher types have the same hash code", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Var n = Var$.MODULE$.apply("a", (CypherType)CTNode$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
            Var r = Var$.MODULE$.apply("a", (CypherType)CTRelationship$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)((AbstractTreeNode)n).hashCode()), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)((AbstractTreeNode)r).hashCode())), (Object)Equality$.MODULE$.default());
            StartNode a = new StartNode((Expr)Var$.MODULE$.apply("rel", (CypherType)CTRelationship$.MODULE$), (CypherType)package$.MODULE$.CTAny());
            StartNode b = new StartNode((Expr)Var$.MODULE$.apply("rel", (CypherType)CTRelationship$.MODULE$), (CypherType)CTNode$.MODULE$);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)a.hashCode()), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)b.hashCode())), (Object)Equality$.MODULE$.default());
        }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("different expressions are not equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Param p = new Param("a", (CypherType)package$.MODULE$.CTAny());
            String x$1 = "a";
            CypherType x$2 = Var$.MODULE$.apply$default$2(x$1);
            Var v = Var$.MODULE$.apply(x$1, x$2);
            return this.convertToAnyShouldWrapper(p, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59), Prettifier$.MODULE$.default()).should(this.not()).equal((Object)v, Equality$.MODULE$.default());
        }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("different expressions have different hash codes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Param p = new Param("a", (CypherType)package$.MODULE$.CTAny());
            String x$3 = "b";
            CypherType x$4 = Var$.MODULE$.apply$default$2(x$3);
            Var v = Var$.MODULE$.apply(x$3, x$4);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)p.hashCode()), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65), Prettifier$.MODULE$.default()).should(this.not()).equal((Object)BoxesRunTime.boxToInteger((int)((AbstractTreeNode)v).hashCode()), Equality$.MODULE$.default());
        }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("alias expression has updated type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Var n = Var$.MODULE$.apply("n", (CypherType)CTNode$.MODULE$);
            String x$5 = "m";
            CypherType x$6 = Var$.MODULE$.apply$default$2(x$5);
            Var aliasVar = Var$.MODULE$.apply(x$5, x$6);
            return this.convertToAnyShouldWrapper(((Expr)n).as(aliasVar).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71), Prettifier$.MODULE$.default()).should(this.equal(((Expr)aliasVar).cypherType()), (Object)Equality$.MODULE$.default());
        }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.describe("CypherType computation", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Var a = Var$.MODULE$.apply("a", (CypherType)CTNode$.MODULE$);
            Var b = Var$.MODULE$.apply("b", CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTInteger$.MODULE$, CTString$.MODULE$})));
            Var c = Var$.MODULE$.apply("c", CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTInteger$.MODULE$, CTString$.MODULE$.nullable()})));
            Var d = Var$.MODULE$.apply("d", CTInteger$.MODULE$.nullable());
            Var e = Var$.MODULE$.apply("e", CTString$.MODULE$.nullable());
            Var datetime = Var$.MODULE$.apply("datetime", (CypherType)CTLocalDateTime$.MODULE$);
            Var duration = Var$.MODULE$.apply("duration", (CypherType)CTDuration$.MODULE$);
            Var number = Var$.MODULE$.apply("number", (CypherType)package$.MODULE$.CTNumber());
            this.it().apply("types Coalesce correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Coalesce((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85), Prettifier$.MODULE$.default()).should(this.equal(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTNode$.MODULE$, CTInteger$.MODULE$, CTString$.MODULE$}))), (Object)Equality$.MODULE$.default());
                this.convertToAnyShouldWrapper(new Coalesce((List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)Nil$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default()).should(this.equal(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTInteger$.MODULE$, CTString$.MODULE$}))), (Object)Equality$.MODULE$.default());
                this.convertToAnyShouldWrapper(new Coalesce((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).should(this.equal(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTNode$.MODULE$, CTInteger$.MODULE$, CTString$.MODULE$}))), (Object)Equality$.MODULE$.default());
                return this.convertToAnyShouldWrapper(new Coalesce((List)new .colon.colon((Object)d, (List)new .colon.colon((Object)e, (List)Nil$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89), Prettifier$.MODULE$.default()).should(this.equal(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTInteger$.MODULE$, CTString$.MODULE$})).nullable()), (Object)Equality$.MODULE$.default());
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            this.it().apply("types ListSegment correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new ListSegment(3, Var$.MODULE$.apply("list", (CypherType)new CTList((CypherType)CTNode$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)CTNode$.MODULE$.nullable()));
                this.convertToAnyShouldWrapper(new ListSegment(3, Var$.MODULE$.apply("list", CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{new CTList((CypherType)CTString$.MODULE$), new CTList((CypherType)CTInteger$.MODULE$)})))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTString$.MODULE$, CTInteger$.MODULE$})).nullable()));
                return this.convertToAnyShouldWrapper(new ListSegment(3, Var$.MODULE$.apply("list", (CypherType)CTNull$.MODULE$)).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)CTNull$.MODULE$));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            this.it().apply("types MapExpression correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                Map mapFields = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)a), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)b), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)c), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)d)}));
                return this.convertToAnyShouldWrapper(new MapExpression(mapFields).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)new CTMap(mapFields.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> ((Expr)x$1).cypherType()))));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            this.it().apply("types ListLit correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new ListLit((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117), Prettifier$.MODULE$.default()).should(this.equal(new CTList(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTNode$.MODULE$, CTInteger$.MODULE$, CTString$.MODULE$})))), (Object)Equality$.MODULE$.default());
                this.convertToAnyShouldWrapper(new ListLit((List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)Nil$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118), Prettifier$.MODULE$.default()).should(this.equal(new CTList(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTInteger$.MODULE$, CTString$.MODULE$.nullable()})))), (Object)Equality$.MODULE$.default());
                return this.convertToAnyShouldWrapper(new ListLit((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119), Prettifier$.MODULE$.default()).should(this.equal(new CTList(CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTNode$.MODULE$, CTInteger$.MODULE$, CTString$.MODULE$})).nullable())), (Object)Equality$.MODULE$.default());
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            this.it().apply("types Explode correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Explode((Expr)Var$.MODULE$.apply("list", (CypherType)new CTList((CypherType)CTNode$.MODULE$))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)CTNode$.MODULE$));
                this.convertToAnyShouldWrapper(new Explode((Expr)Var$.MODULE$.apply("list", CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{new CTList((CypherType)CTString$.MODULE$), new CTList((CypherType)CTInteger$.MODULE$)})))).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)CTUnion$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{CTString$.MODULE$, CTInteger$.MODULE$}))));
                return this.convertToAnyShouldWrapper(new Explode((Expr)Var$.MODULE$.apply("list", (CypherType)CTNull$.MODULE$)).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default()).should((Matcher)new MatchHelper.equalWithTracing((Object)CTVoid$.MODULE$));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            this.it().apply("types Avg correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Avg((Expr)duration).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137), Prettifier$.MODULE$.default()).shouldBe((Object)CTDuration$.MODULE$);
                this.convertToAnyShouldWrapper(new Avg((Expr)number).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138), Prettifier$.MODULE$.default()).shouldBe((Object)package$.MODULE$.CTNumber());
                return this.an(ClassTag$.MODULE$.apply(NoSuitableSignatureForExpr.class)).shouldBe(this.thrownBy((Function0 & Serializable & scala.Serializable)() -> new Avg((Expr)datetime)), Prettifier$.MODULE$.default(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            this.it().apply("types Sum correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Sum((Expr)duration).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default()).shouldBe((Object)CTDuration$.MODULE$);
                this.convertToAnyShouldWrapper(new Sum((Expr)number).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144), Prettifier$.MODULE$.default()).shouldBe((Object)package$.MODULE$.CTNumber());
                return this.an(ClassTag$.MODULE$.apply(NoSuitableSignatureForExpr.class)).shouldBe(this.thrownBy((Function0 & Serializable & scala.Serializable)() -> new Sum((Expr)datetime)), Prettifier$.MODULE$.default(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            this.it().apply("types Size correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Size((Expr)e).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149), Prettifier$.MODULE$.default()).shouldBe((Object)CTInteger$.MODULE$.nullable());
                return this.an(ClassTag$.MODULE$.apply(NoSuitableSignatureForExpr.class)).shouldBe(this.thrownBy((Function0 & Serializable & scala.Serializable)() -> new Size((Expr)datetime)), Prettifier$.MODULE$.default(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            this.it().apply("types Trim correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Trim((Expr)e).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default()).shouldBe((Object)CTString$.MODULE$.nullable());
                return this.an(ClassTag$.MODULE$.apply(NoSuitableSignatureForExpr.class)).shouldBe(this.thrownBy((Function0 & Serializable & scala.Serializable)() -> new Trim((Expr)datetime)), Prettifier$.MODULE$.default(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            this.it().apply("types Range correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Range((Expr)d, (Expr)d, (Option)None$.MODULE$).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159), Prettifier$.MODULE$.default()).shouldBe((Object)new CTList((CypherType)CTInteger$.MODULE$));
                new Range((Expr)d, (Expr)d, (Option)new Some((Object)d)).cypherType();
                return this.an(ClassTag$.MODULE$.apply(NoSuitableSignatureForExpr.class)).shouldBe(this.thrownBy((Function0 & Serializable & scala.Serializable)() -> new Range((Expr)e, (Expr)d, (Option)None$.MODULE$)), Prettifier$.MODULE$.default(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            this.it().apply("types TemporalInstants correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                this.convertToAnyShouldWrapper(new Date((Option)new Some((Object)e)).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165), Prettifier$.MODULE$.default()).shouldBe((Object)CTDate$.MODULE$.nullable());
                this.convertToAnyShouldWrapper(new Duration((Expr)e).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166), Prettifier$.MODULE$.default()).shouldBe((Object)CTDuration$.MODULE$.nullable());
                return this.convertToAnyShouldWrapper(new LocalDateTime((Option)new Some((Object)e)).cypherType(), new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167), Prettifier$.MODULE$.default()).shouldBe((Object)CTLocalDateTime$.MODULE$.nullable());
            }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }, new Position("ExprTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }
}

