/*
 * Copyright (c) 2016-2018 "Neo4j, Inc." [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.opencypher.okapi.ir.impl.parse

import org.neo4j.cypher.internal.frontend.v3_4.AstRewritingMonitor
import org.neo4j.cypher.internal.frontend.v3_4.phases._
import org.neo4j.cypher.internal.util.v3_4.{CypherException, InputPosition}

import scala.reflect.ClassTag

abstract class BlankBaseContext extends BaseContext {
  override def tracer: CompilationPhaseTracer = CompilationPhaseTracer.NO_TRACING
  override def notificationLogger: InternalNotificationLogger = devNullLogger
  override def exceptionCreator: (String, InputPosition) => CypherException = (_, _) => null

  override def monitors: Monitors = new Monitors {
    override def newMonitor[T <: AnyRef: ClassTag](tags: String*): T = {
      new AstRewritingMonitor {
        override def abortedRewriting(obj: AnyRef): Unit = ()
        override def abortedRewritingDueToLargeDNF(obj: AnyRef): Unit = ()
      }
    }.asInstanceOf[T]

    override def addMonitorListener[T](monitor: T, tags: String*): Unit = ()
  }
}
