/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.okapi.tck.test.support.creation.neo4j;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.values.storable.DurationValue;
import org.opencypher.okapi.api.value.CypherValue;
import org.opencypher.okapi.impl.temporal.Duration$;
import org.opencypher.okapi.tck.test.support.creation.neo4j.Neo4JGraphFactory$;
import org.opencypher.okapi.testing.propertygraph.InMemoryTestGraph;
import org.opencypher.okapi.testing.propertygraph.InMemoryTestNode;
import org.opencypher.okapi.testing.propertygraph.InMemoryTestRelationship;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\u0001\u0003\u0011\u0003\u0019\u0012!\u0005(f_RRuI]1qQ\u001a\u000b7\r^8ss*\u00111\u0001B\u0001\u0006]\u0016|GG\u001b\u0006\u0003\u000b\u0019\t\u0001b\u0019:fCRLwN\u001c\u0006\u0003\u000f!\tqa];qa>\u0014HO\u0003\u0002\n\u0015\u0005!A/Z:u\u0015\tYA\"A\u0002uG.T!!\u0004\b\u0002\u000b=\\\u0017\r]5\u000b\u0005=\u0001\u0012AC8qK:\u001c\u0017\u0010\u001d5fe*\t\u0011#A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0015+5\t!AB\u0003\u0017\u0005!\u0005qCA\tOK>$$j\u0012:ba\"4\u0015m\u0019;pef\u001c2!\u0006\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u000eaJ|\u0007/\u001a:us\u001e\u0014\u0018\r\u001d5\u000b\u0005\rb\u0011a\u0002;fgRLgnZ\u0005\u0003K\u0001\u0012A#\u00138NK6|'/_$sCBDg)Y2u_JL\b\"B\u0014\u0016\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0001\u0014\u0011!QS\u0003#b\u0001\n\u0003Y\u0013a\u00024bGR|'/_\u000b\u0002YA\u0011A#\f\u0004\u0005-\t\u0001af\u0005\u0002.1!)q%\fC\u0001aQ\tA\u0006C\u00043[\t\u0007I\u0011B\u001a\u0002\u00179,w\u000e\u000e6TKJ4XM]\u000b\u0002iA\u0011Q'O\u0007\u0002m)\u0011q\u0007O\u0001\bQ\u0006\u0014h.Z:t\u0015\t\u0019\u0001#\u0003\u0002;m\tq1+\u001a:wKJ\u001cuN\u001c;s_2\u001c\bB\u0002\u001f.A\u0003%A'\u0001\u0007oK>$$nU3sm\u0016\u0014\b\u0005C\u0004?[\t\u0007I\u0011A \u0002\u0015%t\u0007/\u001e;He\u0006\u0004\b.F\u0001A!\t\tE)D\u0001C\u0015\t\u0019\u0005(A\u0004he\u0006\u0004\b\u000e\u001a2\n\u0005\u0015\u0013%\u0001F$sCBDG)\u0019;bE\u0006\u001cXmU3sm&\u001cW\r\u0003\u0004H[\u0001\u0006I\u0001Q\u0001\fS:\u0004X\u000f^$sCBD\u0007\u0005C\u0003J[\u0011\u0005!*\u0001\u0004de\u0016\fG/\u001a\u000b\u0004\u0017:;\u0006CA\u0010M\u0013\ti\u0005EA\tJ]6+Wn\u001c:z)\u0016\u001cHo\u0012:ba\"DQa\u0014%A\u0002A\u000b1b\u0019:fCR,\u0017+^3ssB\u0011\u0011\u000b\u0016\b\u00033IK!a\u0015\u000e\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'jAQ\u0001\u0017%A\u0002e\u000b!\u0002]1sC6,G/\u001a:t!\u0011Qv\fU1\u000e\u0003mS!\u0001X/\u0002\u0013%lW.\u001e;bE2,'B\u00010\u001b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003An\u00131!T1q!\tI\"-\u0003\u0002d5\t\u0019\u0011I\\=\t\u000b\u0015lC\u0011\u00024\u0002!\u001d,G\u000f\u0015:pa\u0016\u0014H/_$sCBDW#A&\t\u000b!lC\u0011B5\u0002#\r|gN^3siB\u0013x\u000e]3si&,7\u000fF\u0002k\u0003\u000b\u0001\"a[@\u000f\u00051dhBA7z\u001d\tqwO\u0004\u0002pm:\u0011\u0001/\u001e\b\u0003cRl\u0011A\u001d\u0006\u0003gJ\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tAH\"A\u0002ba&L!A_>\u0002\u000bY\fG.^3\u000b\u0005ad\u0011BA?\u007f\u0003-\u0019\u0015\u0010\u001d5feZ\u000bG.^3\u000b\u0005i\\\u0018\u0002BA\u0001\u0003\u0007\u0011\u0011bQ=qQ\u0016\u0014X*\u00199\u000b\u0005ut\bbBA\u0004O\u0002\u0007\u0011\u0011B\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003\u0002.`!bAq!!\u0004.\t\u0003\ty!A\u0003dY>\u001cX-F\u0001b\u0011%\t\u0019\"\u0006E\u0001B\u0003&A&\u0001\u0005gC\u000e$xN]=!\u0011\u001d\t9\"\u0006C\u0001\u00033\tQ!\u00199qYf$RaSA\u000e\u0003;AaaTA\u000b\u0001\u0004\u0001\u0006B\u0002-\u0002\u0016\u0001\u0007\u0011\f")
public class Neo4JGraphFactory {
    private final ServerControls neo4jServer = TestServerBuilders.newInProcessBuilder().withConfig("dbms.security.auth_enabled", "true").newServer();
    private final GraphDatabaseService inputGraph = this.neo4jServer().graph();

    public static InMemoryTestGraph apply(String string, Map<String, Object> map) {
        return Neo4JGraphFactory$.MODULE$.apply(string, map);
    }

    public static Neo4JGraphFactory factory() {
        return Neo4JGraphFactory$.MODULE$.factory();
    }

    private ServerControls neo4jServer() {
        return this.neo4jServer;
    }

    public GraphDatabaseService inputGraph() {
        return this.inputGraph;
    }

    public InMemoryTestGraph create(String createQuery, Map<String, Object> parameters) {
        Transaction tx = this.inputGraph().beginTx();
        this.inputGraph().execute("MATCH (a) DETACH DELETE a");
        this.inputGraph().execute(createQuery);
        InMemoryTestGraph propertyGraph = this.getPropertyGraph();
        tx.success();
        tx.close();
        return propertyGraph;
    }

    private InMemoryTestGraph getPropertyGraph() {
        List neoNodes = this.inputGraph().getAllNodes().iterator().stream().collect(Collectors.toList());
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoNodes).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Neo4JGraphFactory $outer;

            public final InMemoryTestNode apply(Node neoNode) {
                Set labels = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(neoNode.getLabels()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Label x$1) {
                        return x$1.name();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                long id = neoNode.getId();
                Map<String, CypherValue.CypherValue> properties = this.$outer.org$opencypher$okapi$tck$test$support$creation$neo4j$Neo4JGraphFactory$$convertProperties((Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoNode.getAllProperties()).asScala()).toMap(Predef$.MODULE$.$conforms()));
                return new InMemoryTestNode(id, labels, properties);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        List neoRels = this.inputGraph().getAllRelationships().iterator().stream().collect(Collectors.toList());
        Buffer relationships = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoRels).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Neo4JGraphFactory $outer;

            public final InMemoryTestRelationship apply(Relationship neoRel) {
                String relType = neoRel.getType().name();
                long sourceId = neoRel.getStartNodeId();
                long targetId = neoRel.getEndNodeId();
                long id = neoRel.getId();
                Map<String, CypherValue.CypherValue> properties = this.$outer.org$opencypher$okapi$tck$test$support$creation$neo4j$Neo4JGraphFactory$$convertProperties((Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoRel.getAllProperties()).asScala()).toMap(Predef$.MODULE$.$conforms()));
                return new InMemoryTestRelationship(id, sourceId, targetId, relType, properties);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new InMemoryTestGraph((Seq)nodes, (Seq)relationships);
    }

    public Map<String, CypherValue.CypherValue> org$opencypher$okapi$tck$test$support$creation$neo4j$Neo4JGraphFactory$$convertProperties(Map<String, Object> properties) {
        Map imported = properties.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x0$1) {
                Object object;
                Object object2 = x0$1;
                if (object2 instanceof DurationValue) {
                    DurationValue durationValue = (DurationValue)object2;
                    long x$2 = durationValue.get((TemporalUnit)ChronoUnit.MONTHS);
                    long x$3 = durationValue.get((TemporalUnit)ChronoUnit.DAYS);
                    long x$4 = durationValue.get((TemporalUnit)ChronoUnit.SECONDS);
                    long x$5 = durationValue.get((TemporalUnit)ChronoUnit.NANOS);
                    long x$6 = Duration$.MODULE$.apply$default$1();
                    long x$7 = Duration$.MODULE$.apply$default$3();
                    long x$8 = Duration$.MODULE$.apply$default$5();
                    long x$9 = Duration$.MODULE$.apply$default$6();
                    long x$10 = Duration$.MODULE$.apply$default$8();
                    long x$11 = Duration$.MODULE$.apply$default$9();
                    object = Duration$.MODULE$.apply(x$6, x$2, x$7, x$3, x$8, x$9, x$4, x$10, x$11, x$5);
                } else {
                    object = object2;
                }
                return object;
            }
        });
        return CypherValue.CypherMap$.MODULE$.apply(imported.toSeq());
    }

    public Object close() {
        this.neo4jServer().close();
        return BoxedUnit.UNIT;
    }
}

