/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.okapi.tck.test.support.creation.neo4j;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.opencypher.okapi.api.value.CypherValue;
import org.opencypher.okapi.ir.test.support.creation.propertygraph.TestNode;
import org.opencypher.okapi.ir.test.support.creation.propertygraph.TestPropertyGraph;
import org.opencypher.okapi.ir.test.support.creation.propertygraph.TestRelationship;
import org.opencypher.okapi.tck.test.support.creation.neo4j.Neo4jPropertyGraphFactory$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q<Q!\u0001\u0002\t\u0002M\t\u0011DT3pi)\u0004&o\u001c9feRLxI]1qQ\u001a\u000b7\r^8ss*\u00111\u0001B\u0001\u0006]\u0016|GG\u001b\u0006\u0003\u000b\u0019\t\u0001b\u0019:fCRLwN\u001c\u0006\u0003\u000f!\tqa];qa>\u0014HO\u0003\u0002\n\u0015\u0005!A/Z:u\u0015\tYA\"A\u0002uG.T!!\u0004\b\u0002\u000b=\\\u0017\r]5\u000b\u0005=\u0001\u0012AC8qK:\u001c\u0017\u0010\u001d5fe*\t\u0011#A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0015+5\t!AB\u0003\u0017\u0005!\u0005qCA\rOK>$$\u000e\u0015:pa\u0016\u0014H/_$sCBDg)Y2u_JL8cA\u000b\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"aH\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\u001bA\u0014x\u000e]3sif<'/\u00199i\u0015\t)1E\u0003\u0002\bI)\u0011\u0011\"\n\u0006\u0003M1\t!!\u001b:\n\u0005!\u0002#\u0001\u0006)s_B,'\u000f^=He\u0006\u0004\bNR1di>\u0014\u0018\u0010C\u0003++\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0002'!AQ&\u0006EC\u0002\u0013\u0005a&A\u0004gC\u000e$xN]=\u0016\u0003=\u0002\"\u0001\u0006\u0019\u0007\tY\u0011\u0001!M\n\u0003aaAQA\u000b\u0019\u0005\u0002M\"\u0012a\f\u0005\bkA\u0012\r\u0011\"\u00037\u0003-qWm\u001c\u001bk'\u0016\u0014h/\u001a:\u0016\u0003]\u0002\"\u0001\u000f\u001f\u000e\u0003eR!AO\u001e\u0002\u000f!\f'O\\3tg*\u00111\u0001E\u0005\u0003{e\u0012abU3sm\u0016\u00148i\u001c8ue>d7\u000f\u0003\u0004@a\u0001\u0006IaN\u0001\r]\u0016|GG[*feZ,'\u000f\t\u0005\b\u0003B\u0012\r\u0011\"\u0001C\u0003)Ig\u000e];u\u000fJ\f\u0007\u000f[\u000b\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\u0011aiO\u0001\bOJ\f\u0007\u000f\u001b3c\u0013\tAUI\u0001\u000bHe\u0006\u0004\b\u000eR1uC\n\f7/Z*feZL7-\u001a\u0005\u0007\u0015B\u0002\u000b\u0011B\"\u0002\u0017%t\u0007/\u001e;He\u0006\u0004\b\u000e\t\u0005\u0006\u0019B\"\t!T\u0001\u0007GJ,\u0017\r^3\u0015\u00079\u000b&\f\u0005\u0002 \u001f&\u0011\u0001\u000b\t\u0002\u0012)\u0016\u001cH\u000f\u0015:pa\u0016\u0014H/_$sCBD\u0007\"\u0002*L\u0001\u0004\u0019\u0016aC2sK\u0006$X-U;fef\u0004\"\u0001V,\u000f\u0005e)\u0016B\u0001,\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005YS\u0002\"B.L\u0001\u0004a\u0016A\u00039be\u0006lW\r^3sgB!QLY*e\u001b\u0005q&BA0a\u0003%IW.\\;uC\ndWM\u0003\u0002b5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\rt&aA'baB\u0011\u0011$Z\u0005\u0003Mj\u00111!\u00118z\u0011\u0015A\u0007\u0007\"\u0003j\u0003A9W\r\u001e)s_B,'\u000f^=He\u0006\u0004\b.F\u0001O\u0011\u0015Y\u0007\u0007\"\u0001m\u0003\u0015\u0019Gn\\:f+\u0005!\u0007\u0002\u00038\u0016\u0011\u0003\u0005\u000b\u0015B\u0018\u0002\u0011\u0019\f7\r^8ss\u0002BQ\u0001]\u000b\u0005\u0002E\fQ!\u00199qYf$2A\u0014:t\u0011\u0015\u0011v\u000e1\u0001T\u0011\u0015Yv\u000e1\u0001]\u0001")
public class Neo4jPropertyGraphFactory {
    private final ServerControls neo4jServer = TestServerBuilders.newInProcessBuilder().withConfig("dbms.security.auth_enabled", "true").newServer();
    private final GraphDatabaseService inputGraph = this.neo4jServer().graph();

    public static TestPropertyGraph apply(String string, Map<String, Object> map) {
        return Neo4jPropertyGraphFactory$.MODULE$.apply(string, map);
    }

    public static Neo4jPropertyGraphFactory factory() {
        return Neo4jPropertyGraphFactory$.MODULE$.factory();
    }

    private ServerControls neo4jServer() {
        return this.neo4jServer;
    }

    public GraphDatabaseService inputGraph() {
        return this.inputGraph;
    }

    public TestPropertyGraph create(String createQuery, Map<String, Object> parameters) {
        Transaction tx = this.inputGraph().beginTx();
        this.inputGraph().execute("MATCH (a) DETACH DELETE a");
        this.inputGraph().execute(createQuery);
        TestPropertyGraph propertyGraph = this.getPropertyGraph();
        tx.success();
        tx.close();
        return propertyGraph;
    }

    private TestPropertyGraph getPropertyGraph() {
        List neoNodes = this.inputGraph().getAllNodes().iterator().stream().collect(Collectors.toList());
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoNodes).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TestNode apply(Node neoNode) {
                Set labels = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(neoNode.getLabels()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Label x$1) {
                        return x$1.name();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                long id = neoNode.getId();
                Map properties = CypherValue.CypherMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoNode.getAllProperties()).asScala()).toSeq());
                return new TestNode(id, labels, properties);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        List neoRels = this.inputGraph().getAllRelationships().iterator().stream().collect(Collectors.toList());
        Buffer relationships = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoRels).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TestRelationship apply(Relationship neoRel) {
                String relType = neoRel.getType().name();
                long sourceId = neoRel.getStartNodeId();
                long targetId = neoRel.getEndNodeId();
                long id = neoRel.getId();
                Map properties = CypherValue.CypherMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoRel.getAllProperties()).asScala()).toSeq());
                return new TestRelationship(id, sourceId, targetId, relType, properties);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new TestPropertyGraph((Seq)nodes, (Seq)relationships);
    }

    public Object close() {
        this.neo4jServer().close();
        return BoxedUnit.UNIT;
    }
}

