/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.okapi.tck.test.support.creation.neo4j;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.opencypher.okapi.api.value.CypherValue;
import org.opencypher.okapi.testing.propertygraph.TestGraph;
import org.opencypher.okapi.testing.propertygraph.TestNode;
import org.opencypher.okapi.testing.propertygraph.TestRelationship;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;

public class Neo4JGraphFactory$ {
    private final ServerControls neo4jServer = TestServerBuilders.newInProcessBuilder().withConfig("dbms.security.auth_enabled", "true").newServer();
    private final GraphDatabaseService inputGraph = this.neo4jServer().graph();

    private ServerControls neo4jServer() {
        return this.neo4jServer;
    }

    public GraphDatabaseService inputGraph() {
        return this.inputGraph;
    }

    public TestGraph create(String createQuery, Map<String, Object> parameters) {
        Transaction tx = this.inputGraph().beginTx();
        this.inputGraph().execute("MATCH (a) DETACH DELETE a");
        this.inputGraph().execute(createQuery);
        TestGraph propertyGraph = this.getPropertyGraph();
        tx.success();
        tx.close();
        return propertyGraph;
    }

    private TestGraph getPropertyGraph() {
        List neoNodes = this.inputGraph().getAllNodes().iterator().stream().collect(Collectors.toList());
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoNodes).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TestNode apply(Node neoNode) {
                Set labels = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(neoNode.getLabels()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Label x$1) {
                        return x$1.name();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                long id = neoNode.getId();
                Map properties = CypherValue.CypherMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoNode.getAllProperties()).asScala()).toSeq());
                return new TestNode(id, labels, properties);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        List neoRels = this.inputGraph().getAllRelationships().iterator().stream().collect(Collectors.toList());
        Buffer relationships = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(neoRels).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TestRelationship apply(Relationship neoRel) {
                String relType = neoRel.getType().name();
                long sourceId = neoRel.getStartNodeId();
                long targetId = neoRel.getEndNodeId();
                long id = neoRel.getId();
                Map properties = CypherValue.CypherMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(neoRel.getAllProperties()).asScala()).toSeq());
                return new TestRelationship(id, sourceId, targetId, relType, properties);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new TestGraph((Seq)nodes, (Seq)relationships);
    }

    public Object close() {
        this.neo4jServer().close();
        return BoxedUnit.UNIT;
    }
}

