#!/bin/bash
#
# Copyright 2010 OpenEngSB Division, Vienna University of Technology
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

DIRNAME=`dirname $0`
PROGNAME=`basename $0`

warn() {
    echo "${PROGNAME}: $*"
}

die() {
    warn "$*"
    exit 1
}

detectOS() {
    # OS specific support (must be 'true' or 'false').
    cygwin=false;
    darwin=false;
    aix=false;
    os400=false;
    case "`uname`" in
        CYGWIN*)
            cygwin=true
            ;;
        Darwin*)
            darwin=true
            ;;
        AIX*)
            aix=true
            ;;
        OS400*)
            os400=true
            ;;
    esac
    # For AIX, set an environment variable
    if $aix; then
         export LDR_CNTRL=MAXDATA=0xB0000000@DSA
         export IBM_JAVA_HEAPDUMP_TEXT=true
         echo $LDR_CNTRL
    fi
}

locateHome() {
    if [ "x$KARAF_HOME" != "x" ]; then
        warn "Ignoring predefined value for KARAF_HOME"
    fi

    # In POSIX shells, CDPATH may cause cd to write to stdout
    (unset CDPATH) >/dev/null 2>&1 && unset CDPATH

    KARAF_HOME=`cd $DIRNAME/..; pwd`
    if [ ! -d "$KARAF_HOME" ]; then
        die "KARAF_HOME is not valid: $KARAF_HOME"
    fi
}

locateBase() {
    if [ "x$KARAF_BASE" != "x" ]; then
        if [ ! -d "$KARAF_BASE" ]; then
            die "KARAF_BASE is not valid: $KARAF_BASE"
        fi
    else
        KARAF_BASE=$KARAF_HOME
    fi
}

locateData() {
    if [ "x$KARAF_DATA" != "x" ]; then
        if [ ! -d "$KARAF_DATA" ]; then
            die "KARAF_DATA is not valid: $KARAF_DATA"
        fi
    else
        KARAF_DATA=$KARAF_BASE/data
    fi
}

init() {
    # Determine if there is special OS handling we must perform
    detectOS

    # Locate the Karaf home directory
    locateHome

    # Locate the Karaf base directory
    locateBase
    
    # Locate the Karaf data directory
    locateData
}

run() {
    if $cygwin; then
        KARAF_HOME=`cygpath --path --windows "$KARAF_HOME"`
        KARAF_BASE=`cygpath --path --windows "$KARAF_BASE"`
        KARAF_DATA=`cygpath --path --windows "$KARAF_DATA"`
        CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
    fi
    # Ensure the log directory exists -- we need to have a place to redirect stdout/stderr
    if [ ! -d "$KARAF_DATA/log" ]; then
        mkdir -p "$KARAF_DATA/log"
    fi
    exec "$KARAF_HOME"/bin/karaf stop "$@"
}

main() {
    init
    run "$@"
}

main "$@"

