/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.domain.report.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openengsb.domain.report.common.ReportStore;
import org.openengsb.domain.report.model.Report;

public class InMemoryReportStore
implements ReportStore {
    private Map<String, Map<String, Report>> reports = new HashMap<String, Map<String, Report>>();

    @Override
    public List<Report> getAllReports(String category) {
        Map<String, Report> categoryReports = this.reports.get(category);
        if (categoryReports == null) {
            return new ArrayList<Report>();
        }
        return new ArrayList<Report>(categoryReports.values());
    }

    @Override
    public void storeReport(String category, Report report) {
        Map<String, Report> categoryReports = this.getOrCreateCategory(category);
        categoryReports.put(report.getName(), report);
    }

    @Override
    public void removeReport(String category, Report report) {
        Map<String, Report> categoryReports = this.reports.get(category);
        if (categoryReports == null) {
            return;
        }
        categoryReports.remove(report.getName());
    }

    @Override
    public List<String> getAllCategories() {
        return new ArrayList<String>(this.reports.keySet());
    }

    @Override
    public void removeCategory(String category) {
        this.reports.remove(category);
    }

    @Override
    public void createCategory(String category) {
        this.reports.put(category, new HashMap());
    }

    private Map<String, Report> getOrCreateCategory(String category) {
        Map<String, Report> map = this.reports.get(category);
        if (map == null) {
            map = new HashMap<String, Report>();
            this.reports.put(category, map);
        }
        return map;
    }
}

