/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.domain.report.common;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openengsb.domain.report.common.ReportStore;
import org.openengsb.domain.report.model.FileReportPart;
import org.openengsb.domain.report.model.Report;
import org.openengsb.domain.report.model.ReportPart;

public class FileSystemReportStore
implements ReportStore {
    private File rootDirectory;

    public FileSystemReportStore(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        if (!rootDirectory.exists()) {
            rootDirectory.mkdirs();
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Root directory '" + rootDirectory + "' is not a directory.");
        }
    }

    @Override
    public List<Report> getAllReports(String category) {
        ArrayList<Report> result = new ArrayList<Report>();
        File categoryFile = new File(this.rootDirectory, this.getCategoryFileName(category));
        if (!categoryFile.exists()) {
            return result;
        }
        for (File reportFile : categoryFile.listFiles()) {
            if (reportFile.getName().endsWith(".meta")) continue;
            result.add(this.loadReport(reportFile));
        }
        return result;
    }

    @Override
    public void storeReport(String category, Report report) {
        try {
            this.createCategory(category);
            File categoryFile = new File(this.rootDirectory, this.getCategoryFileName(category));
            File reportFile = this.createReportDirectory(report, categoryFile);
            List<ReportPart> parts = report.getParts();
            for (int i = 0; i < parts.size(); ++i) {
                this.storeReportPart(reportFile, i, parts.get(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeReport(String category, Report report) {
        File categoryFile = new File(this.rootDirectory, this.getCategoryFileName(category));
        if (!categoryFile.exists()) {
            return;
        }
        File reportFile = new File(categoryFile, this.getReportFileName(report));
        if (!reportFile.exists()) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)reportFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getAllCategories() {
        File[] files;
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files = this.rootDirectory.listFiles()) {
            if (!file.isDirectory() || !Arrays.asList(file.list()).contains("category.meta")) continue;
            result.add(this.getCategoryName(file));
        }
        return result;
    }

    @Override
    public void removeCategory(String category) {
        try {
            File categoryFile = new File(this.rootDirectory, this.getCategoryFileName(category));
            if (categoryFile.exists()) {
                FileUtils.deleteDirectory((File)categoryFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createCategory(String category) {
        File categoryFile = new File(this.rootDirectory, this.getCategoryFileName(category));
        if (categoryFile.exists()) {
            return;
        }
        categoryFile.mkdirs();
        this.writeCategoryMetadata(category, categoryFile);
    }

    private Report loadReport(File reportFile) {
        try {
            File metaFile = new File(reportFile, "report.meta");
            Properties reportProps = this.readPropertiesFromFile(metaFile);
            String name = reportProps.getProperty("reportName");
            Report report = new Report(name);
            for (File partFile : this.getAndSortPartFiles(reportFile)) {
                report.addPart(this.loadPart(partFile));
            }
            return report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<File> getAndSortPartFiles(File reportFile) {
        File[] files = reportFile.listFiles();
        ArrayList<File> result = new ArrayList<File>(files.length);
        for (File file : files) {
            if (file.getName().endsWith(".meta")) continue;
            result.add(file);
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int index2;
                String name1 = o1.getName();
                String name2 = o2.getName();
                int index1 = Integer.parseInt(name1.split("[.]")[0]);
                return index1 < (index2 = Integer.parseInt(name2.split("[.]")[0])) ? -1 : (index1 == index2 ? 0 : 1);
            }
        });
        return result;
    }

    private ReportPart loadPart(File partFile) throws IOException {
        String partName = partFile.getName();
        int partIndex = Integer.parseInt(partName.split("[.]")[0]);
        Properties metadata = this.readMetadata(new File(partFile.getParentFile(), partIndex + ".meta"));
        return new FileReportPart(metadata.getProperty("partName"), metadata.getProperty("contentType"), partFile);
    }

    private Properties readMetadata(File file) throws IOException {
        if (!file.exists()) {
            return this.getDefaultProperties();
        }
        return this.readPropertiesFromFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertiesFromFile(File file) throws IOException {
        Properties properties;
        FileReader reader = null;
        try {
            Properties properties2 = new Properties();
            reader = new FileReader(file);
            properties2.load(reader);
            properties = properties2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return properties;
    }

    private Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put("partName", "unknown");
        properties.put("contentType", "text/plain");
        return properties;
    }

    private File createReportDirectory(Report report, File categoryFile) throws IOException {
        String name = this.getReportFileName(report);
        File reportFile = new File(categoryFile, name);
        this.testAndDelete(reportFile);
        reportFile.mkdirs();
        File meta = new File(reportFile, "report.meta");
        Properties properties = new Properties();
        properties.setProperty("reportName", report.getName());
        this.writeProperties(meta, properties);
        return reportFile;
    }

    private void testAndDelete(File reportFile) throws IOException {
        if (reportFile.exists()) {
            FileUtils.deleteDirectory((File)reportFile);
        }
    }

    private void storeReportPart(File reportFile, int partIndex, ReportPart part) throws IOException {
        File partFile = new File(reportFile, partIndex + this.getFileEnding(part.getContentType()));
        this.writeMetadata(reportFile, partIndex, part);
        FileUtils.touch((File)partFile);
        if (part.getContent() != null) {
            FileUtils.writeByteArrayToFile((File)partFile, (byte[])part.getContent());
        }
    }

    private void writeMetadata(File reportFile, int partIndex, ReportPart part) throws IOException {
        File partMetaFile = new File(reportFile, partIndex + ".meta");
        Properties properties = new Properties();
        properties.put("partName", part.getPartName());
        properties.put("contentType", part.getContentType());
        this.writeProperties(partMetaFile, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(File file, Properties properties) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            properties.store(fw, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    private String getFileEnding(String contentType) {
        if ("text/plain".equals(contentType)) {
            return ".txt";
        }
        if ("text/xml".equals(contentType)) {
            return ".xml";
        }
        return ".data";
    }

    private String getReportFileName(Report report) {
        return String.valueOf(report.getName().hashCode());
    }

    private String getCategoryFileName(String category) {
        return String.valueOf(category.hashCode());
    }

    private String getCategoryName(File categoryFile) {
        try {
            File meta = new File(categoryFile, "category.meta");
            Properties properties = this.readPropertiesFromFile(meta);
            return properties.getProperty("categoryName");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeCategoryMetadata(String category, File categoryFile) {
        try {
            File meta = new File(categoryFile, "category.meta");
            Properties properties = new Properties();
            properties.setProperty("categoryName", category);
            this.writeProperties(meta, properties);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

