/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.domains.issue.trac.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.openengsb.core.common.util.AliveState;
import org.openengsb.domains.issue.IssueDomain;
import org.openengsb.domains.issue.models.Issue;
import org.openengsb.domains.issue.models.IssueAttribute;
import org.openengsb.domains.issue.trac.internal.models.TicketHandlerFactory;
import org.openengsb.domains.issue.trac.internal.models.constants.TracFieldConstants;
import org.openengsb.domains.issue.trac.internal.models.constants.TracPriorityConstants;
import org.openengsb.domains.issue.trac.internal.models.constants.TracStatusConstants;
import org.openengsb.domains.issue.trac.internal.models.xmlrpc.Ticket;

public class TracConnector
implements IssueDomain {
    private static Log log = LogFactory.getLog(TracConnector.class);
    private AliveState state = AliveState.DISCONNECTED;
    private final String id;
    private final TicketHandlerFactory ticketFactory;

    public TracConnector(String id, TicketHandlerFactory ticketFactory) {
        this.id = id;
        this.ticketFactory = ticketFactory;
    }

    public String createIssue(Issue issue) {
        Ticket ticket = this.createTicket();
        Hashtable<IssueAttribute, String> attributes = this.generateAttributes(issue);
        Integer issueId = -1;
        try {
            issueId = ticket.create(issue.getSummary(), issue.getDescription(), attributes);
            this.state = AliveState.ONLINE;
            log.info((Object)("Successfully created issue " + issue.getSummary() + ", ID is: " + issueId + "."));
        }
        catch (XmlRpcException e) {
            log.error((Object)("Error creating issue " + issue.getSummary() + ". XMLRPC call failed."));
            this.state = AliveState.OFFLINE;
        }
        return issueId.toString();
    }

    public void deleteIssue(Integer id) {
        try {
            Ticket ticket = this.createTicket();
            ticket.delete(id);
            log.info((Object)("Successfully deleted issue " + id + "."));
        }
        catch (XmlRpcException e) {
            log.error((Object)("Error deleting issue " + id + ". XMLRPC call failed."));
        }
    }

    public void addComment(Integer id, String comment) {
        try {
            Ticket ticket = this.createTicket();
            ticket.update(id, comment);
            log.info((Object)("Successfully added comment to issue " + id + "."));
        }
        catch (XmlRpcException e) {
            log.error((Object)("Error adding comment to issue " + id + ". XMLRPC call failed."));
        }
    }

    public void updateIssue(Integer id, String comment, HashMap<IssueAttribute, String> changes) {
        Hashtable<IssueAttribute, String> attributes = this.translateChanges(changes);
        if (comment == null || comment.equals("")) {
            comment = "[No comment added by author]";
        }
        try {
            Ticket ticket = this.createTicket();
            ticket.update(id, comment, attributes);
            log.info((Object)("Successfully updated issue " + id + " with " + changes.size() + " changes."));
        }
        catch (XmlRpcException e) {
            log.error((Object)("Error updating issue " + id + ". XMLRPC call failed."));
        }
    }

    private Ticket createTicket() {
        if (this.ticketFactory != null) {
            Ticket ticket = this.ticketFactory.createTicket();
            this.state = ticket != null ? AliveState.CONNECTING : AliveState.DISCONNECTED;
            return ticket;
        }
        throw new RuntimeException("tickethandler not yet set");
    }

    public TicketHandlerFactory getTicketHandlerFactory() {
        return this.ticketFactory;
    }

    public String getId() {
        return this.id;
    }

    private Hashtable<IssueAttribute, String> translateChanges(Map<IssueAttribute, String> changes) {
        Hashtable<IssueAttribute, String> attributes = new Hashtable<IssueAttribute, String>();
        for (Map.Entry<IssueAttribute, String> entry : changes.entrySet()) {
            try {
                if (entry.getKey().equals(Issue.Field.DESCRIPTION)) {
                    attributes.put(TracFieldConstants.DESCRIPTION, entry.getValue());
                    continue;
                }
                if (entry.getKey().equals(Issue.Field.OWNER)) {
                    attributes.put(TracFieldConstants.OWNER, entry.getValue());
                    continue;
                }
                if (entry.getKey().equals(Issue.Field.REPORTER)) {
                    attributes.put(TracFieldConstants.SUMMARY, entry.getValue());
                    continue;
                }
                if (entry.getKey().equals(Issue.Field.SUMMARY)) {
                    attributes.put(TracFieldConstants.SUMMARY, entry.getValue());
                    continue;
                }
                if (entry.getKey().equals(Issue.Field.PRIORITY)) {
                    this.addPriority(attributes, Issue.Priority.valueOf((String)entry.getValue()));
                    continue;
                }
                if (!entry.getKey().equals(Issue.Field.STATUS)) continue;
                this.addStatus(attributes, Issue.Status.valueOf((String)entry.getValue()));
            }
            catch (ClassCastException e) {
                log.error((Object)("Wrong value provided for field " + entry.getKey() + ": " + entry.getValue().getClass().getName()));
            }
        }
        return attributes;
    }

    private Hashtable<IssueAttribute, String> generateAttributes(Issue issue) {
        Hashtable<IssueAttribute, String> attributes = new Hashtable<IssueAttribute, String>();
        if (issue.getOwner() != null) {
            attributes.put(TracFieldConstants.OWNER, issue.getOwner());
        }
        if (issue.getReporter() != null) {
            attributes.put(TracFieldConstants.REPORTER, issue.getReporter());
        }
        this.addPriority(attributes, issue.getPriority());
        this.addStatus(attributes, issue.getStatus());
        return attributes;
    }

    private void addPriority(Hashtable<IssueAttribute, String> attributes, Issue.Priority priority) {
        if (priority != null) {
            if (priority.equals((Object)Issue.Priority.HIGH)) {
                attributes.put(TracFieldConstants.PRIORITY, TracPriorityConstants.HIGH.toString());
            } else if (priority.equals((Object)Issue.Priority.IMMEDIATE)) {
                attributes.put(TracFieldConstants.PRIORITY, TracPriorityConstants.IMMEDIATE.toString());
            } else if (priority.equals((Object)Issue.Priority.LOW)) {
                attributes.put(TracFieldConstants.PRIORITY, TracPriorityConstants.LOW.toString());
            } else if (priority.equals((Object)Issue.Priority.NORMAL)) {
                attributes.put(TracFieldConstants.PRIORITY, TracPriorityConstants.NORMAL.toString());
            } else if (priority.equals((Object)Issue.Priority.URGEND)) {
                attributes.put(TracFieldConstants.PRIORITY, TracPriorityConstants.URGENT.toString());
            }
        }
    }

    private void addStatus(Hashtable<IssueAttribute, String> attributes, Issue.Status status) {
        if (status != null) {
            if (status.equals((Object)Issue.Status.NEW)) {
                attributes.put(TracFieldConstants.STATUS, TracStatusConstants.NEW.toString());
            } else if (status.equals((Object)Issue.Status.ASSIGNED)) {
                attributes.put(TracFieldConstants.STATUS, TracStatusConstants.ASSIGNED.toString());
            } else if (status.equals((Object)Issue.Status.CLOSED)) {
                attributes.put(TracFieldConstants.STATUS, TracStatusConstants.CLOSED.toString());
            }
        }
    }

    public AliveState getAliveState() {
        return this.state;
    }
}

