/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.domains.issue.trac.internal;

import java.util.HashMap;
import java.util.Map;
import org.openengsb.core.common.ServiceInstanceFactory;
import org.openengsb.core.common.descriptor.AttributeDefinition;
import org.openengsb.core.common.descriptor.ServiceDescriptor;
import org.openengsb.core.common.validation.MultipleAttributeValidationResult;
import org.openengsb.core.common.validation.MultipleAttributeValidationResultImpl;
import org.openengsb.domains.issue.IssueDomain;
import org.openengsb.domains.issue.trac.internal.TracConnector;
import org.openengsb.domains.issue.trac.internal.models.TicketHandlerFactory;

public class TracServiceInstanceFactory
implements ServiceInstanceFactory<IssueDomain, TracConnector> {
    public ServiceDescriptor getDescriptor(ServiceDescriptor.Builder builder) {
        builder.name("trac.name", new String[0]).description("trac.description", new String[0]);
        builder.attribute(this.buildAttribute(builder, "username", "username.outputMode", "username.outputMode.description")).attribute(builder.newAttribute().id("userPassword").name("userPassword.outputMode").description("userPassword.outputMode.description").defaultValue("").asPassword().build()).attribute(builder.newAttribute().id("serverUrl").name("serverUrl.outputMode").description("serverUrl.outputMode.description").defaultValue("").required().build());
        return builder.build();
    }

    private AttributeDefinition buildAttribute(ServiceDescriptor.Builder builder, String id, String nameId, String descriptionId) {
        return builder.newAttribute().id(id).name(nameId).description(descriptionId).defaultValue("").required().build();
    }

    public void updateServiceInstance(TracConnector instance, Map<String, String> attributes) {
        TicketHandlerFactory ticketFactory = instance.getTicketHandlerFactory();
        this.updateTicketHandlerFactory(attributes, ticketFactory);
    }

    public MultipleAttributeValidationResult updateValidation(TracConnector instance, Map<String, String> attributes) {
        return new MultipleAttributeValidationResultImpl(true, new HashMap());
    }

    public TracConnector createServiceInstance(String id, Map<String, String> attributes) {
        TicketHandlerFactory ticketFactory = new TicketHandlerFactory();
        this.updateTicketHandlerFactory(attributes, ticketFactory);
        TracConnector tracConnector = new TracConnector(id, ticketFactory);
        this.updateServiceInstance(tracConnector, attributes);
        return tracConnector;
    }

    public MultipleAttributeValidationResult createValidation(String id, Map<String, String> attributes) {
        return new MultipleAttributeValidationResultImpl(true, new HashMap());
    }

    private void updateTicketHandlerFactory(Map<String, String> attributes, TicketHandlerFactory ticketFactory) {
        if (attributes.containsKey("serverUrl")) {
            ticketFactory.setServerUrl(attributes.get("serverUrl"));
        }
        if (attributes.containsKey("user")) {
            ticketFactory.setUsername(attributes.get("user"));
        }
        if (attributes.containsKey("password")) {
            ticketFactory.setUserPassword(attributes.get("password"));
        }
    }
}

