/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.domains.issue.trac.internal.models.xmlrpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.common.TypeConverter;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.TypeConverterFactoryImpl;

public class TrackerDynamicProxy {
    private final XmlRpcClient client;
    private final TypeConverterFactory typeConverterFactory;
    private boolean objectMethodLocal;

    public TrackerDynamicProxy(XmlRpcClient client, TypeConverterFactory typeConverterFactory) {
        this.typeConverterFactory = typeConverterFactory;
        this.client = client;
    }

    public TrackerDynamicProxy(XmlRpcClient client) {
        this(client, (TypeConverterFactory)new TypeConverterFactoryImpl());
    }

    public XmlRpcClient getClient() {
        return this.client;
    }

    public boolean isObjectMethodLocal() {
        return this.objectMethodLocal;
    }

    public void setObjectMethodLocal(boolean objectMethodLocal) {
        this.objectMethodLocal = objectMethodLocal;
    }

    public <T> Object newInstance(Class<T> clazz) {
        return this.newInstance(Thread.currentThread().getContextClassLoader(), clazz);
    }

    public <T> T newInstance(ClassLoader classLoader, final Class<T> clazz) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, XmlRpcException {
                if (TrackerDynamicProxy.this.isObjectMethodLocal() && method.getDeclaringClass().equals(Object.class)) {
                    return method.invoke(proxy, args);
                }
                String classname = clazz.getName().replaceFirst(clazz.getPackage().getName() + ".", "").toLowerCase();
                classname = classname.replace("$", ".");
                String methodName = classname + "." + method.getName();
                Object result = TrackerDynamicProxy.this.client.execute(methodName, args);
                TypeConverter typeConverter = TrackerDynamicProxy.this.typeConverterFactory.getTypeConverter(method.getReturnType());
                return typeConverter.convert(result);
            }
        });
    }
}

