/*
 * Decompiled with CFR 0.152.
 */
package org.openengsb.domains.scm.git.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.WorkDirCheckout;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.openengsb.core.common.util.AliveState;
import org.openengsb.domains.scm.ScmDomain;
import org.openengsb.domains.scm.ScmException;

public class GitServiceImpl
implements ScmDomain {
    private String remoteLocation;
    private File localWorkspace;
    private String watchBranch;
    private FileRepository repository;

    public AliveState getAliveState() {
        return AliveState.OFFLINE;
    }

    public boolean poll() {
        if (!this.localWorkspace.isDirectory()) {
            throw new ScmException("local workspace directory does not exist");
        }
        try {
            FetchResult result;
            if (this.repository == null) {
                this.initRepository();
            }
            if ((result = this.doRemoteUpdate()).getTrackingRefUpdate("refs/remotes/origin/" + this.watchBranch) == null) {
                return false;
            }
            if (this.repository.resolve("refs/heads/" + this.watchBranch) == null) {
                this.checkoutWatchBranch(result);
                return true;
            }
            ObjectId remote = this.repository.resolve("refs/remotes/origin/" + this.watchBranch);
            Git git = new Git((Repository)this.repository);
            MergeCommand merge = git.merge().include("remote", (AnyObjectId)remote).setStrategy(MergeStrategy.OURS);
            merge.call();
        }
        catch (Exception e) {
            if (this.repository != null) {
                this.repository.close();
                this.repository = null;
            }
            throw new ScmException((Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkoutWatchBranch(FetchResult result) throws IOException {
        RevCommit commit;
        Ref head = result.getAdvertisedRef("refs/heads/" + this.watchBranch);
        if (head == null) {
            return false;
        }
        if (!"HEAD".equals(head.getName())) {
            RefUpdate u = this.repository.updateRef("HEAD");
            u.disableRefLog();
            u.link(head.getName());
        }
        RevWalk rw = new RevWalk((Repository)this.repository);
        try {
            commit = rw.parseCommit((AnyObjectId)head.getObjectId());
        }
        finally {
            rw.release();
        }
        RefUpdate u = this.repository.updateRef("HEAD");
        u.setNewObjectId((AnyObjectId)commit);
        u.forceUpdate();
        GitIndex index = new GitIndex((Repository)this.repository);
        Tree tree = this.repository.mapTree((ObjectId)commit.getTree());
        WorkDirCheckout co = new WorkDirCheckout((Repository)this.repository, this.repository.getWorkTree(), index, tree);
        co.checkout();
        index.write();
        return true;
    }

    protected FetchResult doRemoteUpdate() throws URISyntaxException, NotSupportedException, TransportException {
        List remoteConfig = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
        Transport transport = Transport.open((Repository)this.repository, (RemoteConfig)((RemoteConfig)remoteConfig.get(0)));
        FetchResult result = transport.fetch((ProgressMonitor)NullProgressMonitor.INSTANCE, null);
        return result;
    }

    private void initRepository() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setWorkTree(this.localWorkspace);
        this.repository = builder.build();
        if (!new File(this.localWorkspace, ".git").isDirectory()) {
            this.repository.create();
            this.repository.getConfig().setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
            this.repository.getConfig().setString("remote", "origin", "url", this.remoteLocation);
            this.repository.getConfig().setString("branch", this.watchBranch, "remote", "origin");
            this.repository.getConfig().setString("branch", this.watchBranch, "merge", "refs/heads/" + this.watchBranch);
            this.repository.getConfig().save();
        }
    }

    public void export(File directory) {
        try {
            FileUtils.copyDirectory((File)this.localWorkspace, (File)directory, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.getName().equals(".git");
                }
            });
        }
        catch (IOException e) {
            throw new ScmException((Throwable)e);
        }
    }

    public void setRemoteLocation(String remoteLocation) {
        if (remoteLocation.startsWith("file:/") && !remoteLocation.startsWith("file:///")) {
            remoteLocation = remoteLocation.replace("file:/", "file:///");
        }
        this.remoteLocation = remoteLocation;
    }

    public void setLocalWorkspace(String localWorkspace) {
        this.localWorkspace = new File(localWorkspace);
    }

    public void setWatchBranch(String watchBranch) {
        this.watchBranch = watchBranch;
    }

    public FileRepository getRepository() {
        return this.repository;
    }
}

