/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScriptOrFnScope {
    private int braceNesting;
    private ScriptOrFnScope parentScope;
    private ArrayList<ScriptOrFnScope> subScopes;
    private Hashtable<String, JavaScriptIdentifier> identifiers = new Hashtable();
    private Hashtable<String, String> hints = new Hashtable();
    private boolean markedForMunging = true;
    private int varcount = 0;

    ScriptOrFnScope(int braceNesting, ScriptOrFnScope parentScope) {
        this.braceNesting = braceNesting;
        this.parentScope = parentScope;
        this.subScopes = new ArrayList();
        if (parentScope != null) {
            parentScope.subScopes.add(this);
        }
    }

    int getBraceNesting() {
        return this.braceNesting;
    }

    ScriptOrFnScope getParentScope() {
        return this.parentScope;
    }

    JavaScriptIdentifier declareIdentifier(String symbol) {
        JavaScriptIdentifier identifier = this.identifiers.get(symbol);
        if (identifier == null) {
            identifier = new JavaScriptIdentifier(symbol, this);
            this.identifiers.put(symbol, identifier);
        }
        return identifier;
    }

    JavaScriptIdentifier getIdentifier(String symbol) {
        return this.identifiers.get(symbol);
    }

    void addHint(String variableName, String variableType) {
        this.hints.put(variableName, variableType);
    }

    void preventMunging() {
        if (this.parentScope != null) {
            this.markedForMunging = false;
        }
    }

    private ArrayList<String> getUsedSymbols() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JavaScriptIdentifier> elements = this.identifiers.elements();
        while (elements.hasMoreElements()) {
            JavaScriptIdentifier identifier = elements.nextElement();
            String mungedValue = identifier.getMungedValue();
            if (mungedValue == null) {
                mungedValue = identifier.getValue();
            }
            result.add(mungedValue);
        }
        return result;
    }

    private ArrayList<String> getAllUsedSymbols() {
        ArrayList<String> result = new ArrayList<String>();
        ScriptOrFnScope scope = this;
        while (scope != null) {
            result.addAll(scope.getUsedSymbols());
            scope = scope.parentScope;
        }
        return result;
    }

    int incrementVarCount() {
        ++this.varcount;
        return this.varcount;
    }

    void munge() {
        if (!this.markedForMunging) {
            return;
        }
        int pickFromSet = 1;
        if (this.parentScope != null) {
            ArrayList<String> freeSymbols = new ArrayList<String>();
            freeSymbols.addAll(JavaScriptCompressor.ones);
            freeSymbols.removeAll(this.getAllUsedSymbols());
            if (freeSymbols.size() == 0) {
                pickFromSet = 2;
                freeSymbols.addAll(JavaScriptCompressor.twos);
                freeSymbols.removeAll(this.getAllUsedSymbols());
            }
            if (freeSymbols.size() == 0) {
                pickFromSet = 3;
                freeSymbols.addAll(JavaScriptCompressor.threes);
                freeSymbols.removeAll(this.getAllUsedSymbols());
            }
            if (freeSymbols.size() == 0) {
                throw new IllegalStateException("The YUI Compressor ran out of symbols. Aborting...");
            }
            Enumeration<JavaScriptIdentifier> elements = this.identifiers.elements();
            while (elements.hasMoreElements()) {
                JavaScriptIdentifier identifier;
                if (freeSymbols.size() == 0) {
                    if (++pickFromSet == 2) {
                        freeSymbols.addAll(JavaScriptCompressor.twos);
                    } else if (pickFromSet == 3) {
                        freeSymbols.addAll(JavaScriptCompressor.threes);
                    } else {
                        throw new IllegalStateException("The YUI Compressor ran out of symbols. Aborting...");
                    }
                    freeSymbols.removeAll(this.getAllUsedSymbols());
                }
                String mungedValue = (identifier = elements.nextElement()).isMarkedForMunging() ? (String)freeSymbols.remove(0) : identifier.getValue();
                identifier.setMungedValue(mungedValue);
            }
        }
        for (int i = 0; i < this.subScopes.size(); ++i) {
            ScriptOrFnScope scope = this.subScopes.get(i);
            scope.munge();
        }
    }
}

