/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.odlabs.wiquery.core.commons.JavaScriptCallable;

public class JavaScriptBuilder
implements Serializable {
    private static final long serialVersionUID = -3816412033699069800L;
    private static final String ON_DOM_READY_OPEN = "$(document).ready(function (){\n";
    private static final String ON_DOM_READY_CLOSE = "\n})";
    private StringBuilder stringBuilder = new StringBuilder();
    private Component component;
    private IHeaderResponse response;

    public JavaScriptBuilder(Component component) {
        this();
        this.component = component;
        component.setOutputMarkupId(true);
    }

    public JavaScriptBuilder() {
    }

    public void bindResponse(IHeaderResponse response) {
        this.response = response;
    }

    public JavaScriptBuilder $() {
        this.stringBuilder.append("$(");
        if (this.component != null) {
            this.stringBuilder.append("'");
            this.stringBuilder.append("#");
            this.stringBuilder.append(this.component.getMarkupId(true));
            this.stringBuilder.append("'");
        }
        this.stringBuilder.append(")");
        return this;
    }

    public JavaScriptBuilder $(String cssSelector) {
        if (cssSelector == null || "".equals(cssSelector)) {
            return this.$();
        }
        this.stringBuilder.append("$('");
        if (this.component != null) {
            this.stringBuilder.append("#");
            this.stringBuilder.append(this.component.getMarkupId(true));
            this.stringBuilder.append(" ");
        }
        this.stringBuilder.append(cssSelector);
        this.stringBuilder.append("')");
        return this;
    }

    public JavaScriptBuilder call(JavaScriptCallable queryCallable) {
        this.stringBuilder.append(".");
        this.stringBuilder.append(queryCallable.statement());
        return this;
    }

    public JavaScriptBuilder addClass(String cssClass) {
        this.stringBuilder.append("addClass('");
        this.stringBuilder.append(cssClass);
        this.stringBuilder.append("');");
        return this;
    }

    public JavaScriptBuilder removeClass(String cssClass) {
        this.stringBuilder.append("removeClass('");
        this.stringBuilder.append(cssClass);
        this.stringBuilder.append("');");
        return this;
    }

    public JavaScriptBuilder toggleClass(String cssClass) {
        this.stringBuilder.append("toggleClass('");
        this.stringBuilder.append(cssClass);
        this.stringBuilder.append("');");
        return this;
    }

    public JavaScriptBuilder attr(String attributeKey, String attributeValue) {
        this.stringBuilder.append("attr('");
        this.stringBuilder.append(attributeKey);
        this.stringBuilder.append(", ");
        this.stringBuilder.append(attributeValue);
        this.stringBuilder.append("');");
        return this;
    }

    public JavaScriptBuilder removeAttr(String attributeKey) {
        this.stringBuilder.append("removeAttr('");
        this.stringBuilder.append(attributeKey);
        this.stringBuilder.append("');");
        return this;
    }

    public String getStatement() {
        this.stringBuilder.append(";\n");
        return this.stringBuilder.toString();
    }

    public String getDomReadyStatement() {
        StringBuilder domReadyStringBuilder = new StringBuilder();
        domReadyStringBuilder.append(ON_DOM_READY_OPEN);
        domReadyStringBuilder.append((CharSequence)this.stringBuilder);
        domReadyStringBuilder.append(ON_DOM_READY_CLOSE);
        domReadyStringBuilder.append(";\n");
        return domReadyStringBuilder.toString();
    }

    public void appendJavaScript() {
        IRequestTarget requestTarget = this.component.getRequestCycle().getRequestTarget();
        if (requestTarget == null || !(requestTarget instanceof AjaxRequestTarget)) {
            StringBuilder domReadyStringBuilder = new StringBuilder();
            domReadyStringBuilder.append(ON_DOM_READY_OPEN);
            domReadyStringBuilder.append((CharSequence)this.stringBuilder);
            domReadyStringBuilder.append(ON_DOM_READY_CLOSE);
            domReadyStringBuilder.append(";\n");
            this.response.renderString((CharSequence)("<script type=\"text/javascript\">" + domReadyStringBuilder.toString() + "</script>"));
        } else {
            AjaxRequestTarget ajaxRequestTarget = (AjaxRequestTarget)requestTarget;
            ajaxRequestTarget.appendJavascript(this.getStatement());
        }
    }
}

