/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.odlabs.wiquery.core.commons.IWiQueryPlugin;
import org.odlabs.wiquery.core.commons.WiQueryRenderingListener;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.commons.WiQuerySettings;
import org.odlabs.wiquery.core.commons.listener.JQueryCoreRenderingListener;
import org.odlabs.wiquery.core.commons.listener.JQueryUICoreRenderingListener;
import org.odlabs.wiquery.core.commons.listener.WiQueryPluginRenderingListener;
import org.odlabs.wiquery.core.commons.merge.WiQueryHeaderResponse;
import org.odlabs.wiquery.core.commons.merge.WiQueryMergedJavaScriptResourceReference;
import org.odlabs.wiquery.core.commons.merge.WiQueryMergedStyleSheetResourceReference;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiQueryCoreHeaderContributor
implements Serializable,
IHeaderContributor {
    private static final long serialVersionUID = -347081993448442637L;
    private static final MetaDataKey<Boolean> WIQUERY_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    private static final MetaDataKey<Long> WIQUERY_PAGE_KEY = new MetaDataKey<Long>(){
        private static final long serialVersionUID = 1L;
    };
    private static final MetaDataKey<WiQueryHeaderResponse> WIQUERY_MERGER = new MetaDataKey<WiQueryHeaderResponse>(){
        private static final long serialVersionUID = 1L;
    };
    private Component owner;

    public WiQueryCoreHeaderContributor(Component component) {
        this.owner = component;
        this.owner.setMetaData(WiQueryRenderingListener.WI_QUERY_RENDERED, (Object)true);
    }

    public void renderHead(IHeaderResponse response) {
        AjaxRequestTarget ajaxRequestTarget = AjaxRequestTarget.get();
        if (ajaxRequestTarget == null) {
            this.renderResponse(response);
        } else {
            this.renderAjaxResponse(response, ajaxRequestTarget);
        }
    }

    private void renderResponse(IHeaderResponse response) {
        Boolean rendered;
        Page page = RequestCycle.get().getResponsePage();
        if (page == null) {
            rendered = (Boolean)RequestCycle.get().getMetaData(WIQUERY_KEY);
        } else {
            Long renderTime = (Long)page.getMetaData(WIQUERY_PAGE_KEY);
            rendered = renderTime != null && renderTime.equals(RequestCycle.get().getStartTime());
            page.setMetaData(WIQUERY_PAGE_KEY, (Object)RequestCycle.get().getStartTime());
        }
        RequestCycle.get().setMetaData(WIQUERY_KEY, (Object)Boolean.TRUE);
        if (rendered == null || !rendered.booleanValue()) {
            Object headerResponse;
            WiQueryHeaderResponse wiQueryHeaderResponse;
            WiQuerySettings settings = WiQuerySettings.get();
            List<WiQueryPluginRenderingListener> pluginRenderingListeners = this.getRenderingListeners(settings);
            WiQueryPluginCollector visitor = new WiQueryPluginCollector();
            if (page != null) {
                page.visitChildren((Component.IVisitor)visitor);
                visitor.component((Component)page);
            }
            if (settings.isEnableResourcesMerging() && page != null) {
                wiQueryHeaderResponse = (WiQueryHeaderResponse)page.getMetaData(WIQUERY_MERGER);
                if (wiQueryHeaderResponse == null) {
                    wiQueryHeaderResponse = new WiQueryHeaderResponse();
                    page.setMetaData(WIQUERY_MERGER, (Object)wiQueryHeaderResponse);
                }
                wiQueryHeaderResponse.setIHeaderResponse(response);
                headerResponse = wiQueryHeaderResponse;
            } else {
                wiQueryHeaderResponse = null;
                headerResponse = response;
            }
            WiQueryResourceManager manager = new WiQueryResourceManager();
            JsStatement jsStatement = new JsStatement();
            for (IWiQueryPlugin plugin : visitor.getPlugins()) {
                JsStatement tempStatement = plugin.statement();
                if (tempStatement != null) {
                    jsStatement.append("\t" + tempStatement.render() + "\n");
                }
                for (WiQueryPluginRenderingListener listener : pluginRenderingListeners) {
                    listener.onRender(plugin, manager, (IHeaderResponse)headerResponse);
                }
                plugin.contribute(manager);
            }
            this.initializeResourceManager((IHeaderResponse)headerResponse, manager);
            this.mergeResources(response, settings, wiQueryHeaderResponse);
            JsQuery jsq = new JsQuery();
            jsq.setStatement(jsStatement);
            jsq.renderHead(response, RequestCycle.get().getRequestTarget());
        }
    }

    private void initializeResourceManager(IHeaderResponse headerResponse, WiQueryResourceManager manager) {
        if (WiQuerySettings.get().isEnableWiqueryResourceManagement()) {
            manager.initialize(headerResponse);
        }
    }

    private void renderAjaxResponse(IHeaderResponse response, AjaxRequestTarget ajaxRequestTarget) {
        Object headerResponse;
        WiQueryHeaderResponse wiQueryHeaderResponse;
        WiQuerySettings settings = WiQuerySettings.get();
        List<WiQueryPluginRenderingListener> pluginRenderingListeners = this.getRenderingListeners(settings);
        if (settings.isEnableResourcesMerging()) {
            Page page = RequestCycle.get().getResponsePage();
            if (page == null || page.getMetaData(WIQUERY_MERGER) == null) {
                wiQueryHeaderResponse = null;
                headerResponse = response;
            } else {
                wiQueryHeaderResponse = (WiQueryHeaderResponse)page.getMetaData(WIQUERY_MERGER);
                wiQueryHeaderResponse.setIHeaderResponse(response);
                headerResponse = wiQueryHeaderResponse;
            }
        } else {
            wiQueryHeaderResponse = null;
            headerResponse = response;
        }
        WiQueryResourceManager manager = new WiQueryResourceManager();
        if (this.owner.determineVisibility()) {
            if (this.owner instanceof IWiQueryPlugin) {
                this.renderPlugin(response, ajaxRequestTarget, (IWiQueryPlugin)this.owner, pluginRenderingListeners, manager, (IHeaderResponse)headerResponse);
            }
            for (IBehavior behavior : this.owner.getBehaviors()) {
                if (!(behavior instanceof IWiQueryPlugin) || !behavior.isEnabled(this.owner)) continue;
                this.renderPlugin(response, ajaxRequestTarget, (IWiQueryPlugin)behavior, pluginRenderingListeners, manager, (IHeaderResponse)headerResponse);
            }
        }
        this.initializeResourceManager((IHeaderResponse)headerResponse, manager);
        this.mergeResources(response, settings, wiQueryHeaderResponse);
    }

    private void renderPlugin(IHeaderResponse response, AjaxRequestTarget ajaxRequestTarget, IWiQueryPlugin plugin, List<WiQueryPluginRenderingListener> pluginRenderingListeners, WiQueryResourceManager manager, IHeaderResponse headerResponse) {
        JsStatement statement = plugin.statement();
        if (statement != null) {
            JsQuery jsq = new JsQuery();
            jsq.setStatement(statement.append("\n"));
            jsq.renderHead(response, (IRequestTarget)ajaxRequestTarget);
        }
        for (WiQueryPluginRenderingListener listener : pluginRenderingListeners) {
            listener.onRender(plugin, manager, headerResponse);
        }
        plugin.contribute(manager);
    }

    private List<WiQueryPluginRenderingListener> getRenderingListeners(WiQuerySettings instanciation) {
        ArrayList<WiQueryPluginRenderingListener> pluginRenderingListeners = new ArrayList<WiQueryPluginRenderingListener>();
        pluginRenderingListeners.add(new JQueryCoreRenderingListener());
        pluginRenderingListeners.add(new JQueryUICoreRenderingListener());
        ListIterator<WiQueryPluginRenderingListener> iterator = instanciation.getListeners();
        while (iterator.hasNext()) {
            pluginRenderingListeners.add((WiQueryPluginRenderingListener)iterator.next());
        }
        return pluginRenderingListeners;
    }

    private void mergeResources(IHeaderResponse response, WiQuerySettings settings, WiQueryHeaderResponse wiQueryHeaderResponse) {
        if (settings.isEnableResourcesMerging() && wiQueryHeaderResponse != null) {
            if (!wiQueryHeaderResponse.getStylesheet().isEmpty()) {
                response.renderCSSReference((ResourceReference)new WiQueryMergedStyleSheetResourceReference(wiQueryHeaderResponse));
            }
            for (ResourceReference ref : wiQueryHeaderResponse.getStylesheetUnmergeable()) {
                response.renderCSSReference(ref);
            }
            if (!wiQueryHeaderResponse.getJavascript().isEmpty()) {
                response.renderJavascriptReference((ResourceReference)new WiQueryMergedJavaScriptResourceReference(wiQueryHeaderResponse));
            }
            for (ResourceReference ref : wiQueryHeaderResponse.getJavascriptUnmergeable()) {
                response.renderJavascriptReference(ref);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WiQueryPluginCollector
    implements Component.IVisitor<Component> {
        private List<IWiQueryPlugin> plugins = new ArrayList<IWiQueryPlugin>();

        private WiQueryPluginCollector() {
        }

        public List<IWiQueryPlugin> getPlugins() {
            return this.plugins;
        }

        public Object component(Component component) {
            if (component.determineVisibility()) {
                if (component instanceof IWiQueryPlugin) {
                    this.plugins.add((IWiQueryPlugin)component);
                }
                for (IBehavior behavior : component.getBehaviors()) {
                    if (!(behavior instanceof IWiQueryPlugin) || !behavior.isEnabled(component)) continue;
                    this.plugins.add((IWiQueryPlugin)behavior);
                }
                return CONTINUE_TRAVERSAL;
            }
            return CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
        }
    }
}

