/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.wicket.Application;
import org.apache.wicket.IInitializer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.util.lang.Objects;
import org.odlabs.wiquery.core.commons.IWiQueryInitializer;
import org.odlabs.wiquery.core.commons.IWiQuerySettings;
import org.odlabs.wiquery.core.commons.WiQueryRenderingListener;
import org.odlabs.wiquery.core.commons.WiQuerySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiQueryInitializer
implements IInitializer {
    public static final MetaDataKey<WiQuerySettings> WIQUERY_INSTANCE_KEY = new MetaDataKey<WiQuerySettings>(){
        private static final long serialVersionUID = 1L;
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(WiQueryInitializer.class);

    public void init(Application application) {
        application.addPostComponentOnBeforeRenderListener((IComponentOnBeforeRenderListener)new WiQueryRenderingListener());
        WiQuerySettings settings = application instanceof IWiQuerySettings ? ((IWiQuerySettings)application).getWiQuerySettings() : null;
        application.setMetaData(WIQUERY_INSTANCE_KEY, (Object)(settings == null ? new WiQuerySettings() : settings));
        this.retrieveAndCallInitializers(application, settings);
    }

    private IWiQueryInitializer getIWiQueryInitializer(String className) {
        if (className == null) {
            return null;
        }
        return (IWiQueryInitializer)Objects.newInstance((String)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAndCallInitializers(Application application, WiQuerySettings wiQuerySettings) {
        InputStream in = null;
        Iterator resources = null;
        ArrayList<IWiQueryInitializer> initializers = new ArrayList<IWiQueryInitializer>();
        Properties properties = null;
        URL url = null;
        try {
            resources = application.getApplicationSettings().getClassResolver().getResources("wiquery.properties");
            while (resources.hasNext()) {
                try {
                    url = (URL)resources.next();
                    LOGGER.info("Find the wiQuery initializer:", (Object)url.toString());
                    properties = new Properties();
                    in = url.openStream();
                    properties.load(in);
                    IWiQueryInitializer wiQueryInitializer = this.getIWiQueryInitializer(properties.getProperty("initializer"));
                    if (wiQueryInitializer != null) {
                        initializers.add(wiQueryInitializer);
                    }
                    if ((wiQueryInitializer = this.getIWiQueryInitializer(properties.getProperty(application.getName() + "-initializer"))) == null) continue;
                    initializers.add(wiQueryInitializer);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load initializers file", (Throwable)e);
        }
        if (initializers.size() > 0) {
            for (IWiQueryInitializer initializer : initializers) {
                LOGGER.info("[" + application.getName() + "] init: " + initializer);
                initializer.init(application, wiQuerySettings);
            }
        }
    }
}

