/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.odlabs.wiquery.core.commons.compressed.StyleSheetResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiQueryResourceManager
implements Serializable {
    private static final long serialVersionUID = 6492292431833226643L;
    private ArrayList<ResourceReference> javascriptResources = new ArrayList();
    private ArrayList<ResourceReference> cssResources = new ArrayList();

    public void initialize(IHeaderResponse response) {
        int i;
        for (i = 0; i < this.javascriptResources.size(); ++i) {
            response.renderJavascriptReference(this.javascriptResources.get(i));
        }
        for (i = 0; i < this.cssResources.size(); ++i) {
            response.renderCSSReference(this.cssResources.get(i));
        }
    }

    public void addJavaScriptResource(ResourceReference reference) {
        this.javascriptResources.add(reference);
    }

    public void addJavaScriptResource(Class<?> scope, String path) {
        this.javascriptResources.add((ResourceReference)new JavascriptResourceReference(scope, path));
    }

    public void addCssResource(ResourceReference reference) {
        this.cssResources.add(reference);
    }

    public void addCssResource(Class<?> scope, String path) {
        this.cssResources.add(new StyleSheetResourceReference(scope, path));
    }

    protected void clearResources() {
        this.javascriptResources.clear();
        this.cssResources.clear();
    }
}

