/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons.compressed;

import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.wicket.javascript.IJavascriptCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YUIStyleSheetCompressor
implements IJavascriptCompressor {
    private static final Logger log = LoggerFactory.getLogger(YUIStyleSheetCompressor.class);

    public String compress(String original) {
        long startTime = System.currentTimeMillis();
        StringReader originalCssReader = new StringReader(original);
        StringWriter compressedCss = new StringWriter();
        try {
            CssCompressor compressor = new CssCompressor(originalCssReader);
            compressor.compress(compressedCss, -1);
            compressedCss.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return original;
        }
        catch (RuntimeException e) {
            log.error("Failed to compress stylesheet, no reason was given.");
            return original;
        }
        long endTime = System.currentTimeMillis();
        log.debug("Compressed CSS in " + (endTime - startTime) + " ms.");
        return compressedCss.toString();
    }
}

