/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons.merge;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.odlabs.wiquery.core.commons.merge.WiQueryNotMerged;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiQueryHeaderResponse
extends HeaderResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<ResourceReference> javascript = new LinkedHashSet<ResourceReference>();
    private final Set<ResourceReference> stylesheet = new LinkedHashSet<ResourceReference>();
    private final Set<ResourceReference> javascriptUnmergeable = new LinkedHashSet<ResourceReference>();
    private final Set<ResourceReference> stylesheetUnmergeable = new LinkedHashSet<ResourceReference>();
    private final Set<Object> objects = new HashSet<Object>();
    private transient IHeaderResponse iHeaderResponse;

    public static CharSequence getMergedResourceName(Collection<ResourceReference> resources) {
        StringBuffer buffer = new StringBuffer();
        for (ResourceReference r : resources) {
            buffer.append(r.getClass().getSimpleName() + "_");
            buffer.append(r.getName().replace("/", ":"));
        }
        return buffer;
    }

    public WiQueryHeaderResponse() {
        this(null);
    }

    public WiQueryHeaderResponse(IHeaderResponse iHeaderResponse) {
        this.iHeaderResponse = iHeaderResponse;
    }

    public IHeaderResponse getIHeaderResponse() {
        return this.iHeaderResponse;
    }

    public Set<ResourceReference> getJavascript() {
        return this.javascript;
    }

    public Set<ResourceReference> getJavascriptUnmergeable() {
        return this.javascriptUnmergeable;
    }

    protected Response getRealResponse() {
        return null;
    }

    public Set<ResourceReference> getStylesheet() {
        return this.stylesheet;
    }

    public Set<ResourceReference> getStylesheetUnmergeable() {
        return this.stylesheetUnmergeable;
    }

    protected Boolean isMergeable(ResourceReference resource) {
        return !resource.getClass().isAnnotationPresent(WiQueryNotMerged.class);
    }

    private void markResourceReference(Object object) {
        this.iHeaderResponse.markRendered(object);
        this.objects.add(object);
    }

    public void renderCSSReference(ResourceReference reference) {
        List<Object> object = Arrays.asList("css", RequestCycle.get().urlFor(reference), null);
        if (this.iHeaderResponse != null && !this.iHeaderResponse.wasRendered(object) && !this.wasInternalRendered(object)) {
            if (this.isMergeable(reference).booleanValue()) {
                this.stylesheet.add(reference);
            } else {
                this.stylesheetUnmergeable.add(reference);
            }
            this.markResourceReference(object);
        }
    }

    public void renderCSSReference(ResourceReference reference, String media) {
        List<Object> object = Arrays.asList("css", RequestCycle.get().urlFor(reference), media);
        if (this.iHeaderResponse != null && !this.iHeaderResponse.wasRendered(object) && !this.wasInternalRendered(object)) {
            if (this.isMergeable(reference).booleanValue()) {
                this.stylesheet.add(reference);
            } else {
                this.stylesheetUnmergeable.add(reference);
            }
            this.markResourceReference(object);
        }
    }

    public void renderJavascriptReference(ResourceReference reference) {
        List<Object> object = Arrays.asList("javascript", RequestCycle.get().urlFor(reference));
        if (this.iHeaderResponse != null && !this.iHeaderResponse.wasRendered(object) && !this.wasInternalRendered(object)) {
            if (this.isMergeable(reference).booleanValue()) {
                this.javascript.add(reference);
            } else {
                this.javascriptUnmergeable.add(reference);
            }
            this.markResourceReference(object);
        }
    }

    public void renderJavascriptReference(ResourceReference reference, String id) {
        List<Object> object = Arrays.asList("javascript", RequestCycle.get().urlFor(reference));
        if (this.iHeaderResponse != null && !this.iHeaderResponse.wasRendered(object) && !this.wasInternalRendered(object)) {
            if (this.isMergeable(reference).booleanValue()) {
                this.javascript.add(reference);
            } else {
                this.javascriptUnmergeable.add(reference);
            }
            this.markResourceReference(object);
        }
    }

    public void setIHeaderResponse(IHeaderResponse iHeaderResponse) {
        this.iHeaderResponse = iHeaderResponse;
        if (iHeaderResponse != null) {
            if (RequestCycle.get().getRequestTarget() instanceof AjaxRequestTarget) {
                for (Object obj : this.objects) {
                    iHeaderResponse.markRendered(obj);
                }
            } else {
                this.objects.clear();
            }
        }
        this.javascript.clear();
        this.stylesheet.clear();
        this.javascriptUnmergeable.clear();
        this.stylesheetUnmergeable.clear();
    }

    private boolean wasInternalRendered(Object object) {
        return this.objects.contains(object);
    }
}

