/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons.merge;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.javascript.IJavascriptCompressor;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.time.Time;
import org.odlabs.wiquery.core.commons.merge.WiQueryHeaderResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiQueryMergedJavaScriptResourceReference
extends ResourceReference
implements IClusterable {
    private static final long serialVersionUID = 6038498199511603297L;
    private static final String TEMPLATE_NAME = "wiquery-merged.js";
    private static final String CONTENT_TYPE = "text/javascript";
    private static final Logger LOGGER = LoggerFactory.getLogger(WiQueryMergedJavaScriptResourceReference.class);
    private PackagedTextTemplate jstemplate;
    private WiQueryHeaderResponse wiQueryHeaderResponse;

    public WiQueryMergedJavaScriptResourceReference(WiQueryHeaderResponse wiQueryHeaderResponse) {
        super(WiQueryMergedJavaScriptResourceReference.class, "wiquery-merged.js_" + WiQueryHeaderResponse.getMergedResourceName(wiQueryHeaderResponse.getJavascript()));
        this.wiQueryHeaderResponse = wiQueryHeaderResponse;
        this.jstemplate = new PackagedTextTemplate(WiQueryMergedJavaScriptResourceReference.class, TEMPLATE_NAME);
    }

    public Time lastModifiedTime() {
        return this.jstemplate.lastModifiedTime();
    }

    protected Resource newResource() {
        return new Resource(){
            private static final long serialVersionUID = 1L;

            public IResourceStream getResourceStream() {
                String temp = null;
                Application application = Application.get();
                StringBuffer buffer = new StringBuffer();
                IJavascriptCompressor compressor = application.getResourceSettings().getJavascriptCompressor();
                for (ResourceReference ref : WiQueryMergedJavaScriptResourceReference.this.wiQueryHeaderResponse.getJavascript()) {
                    ref.bind(Application.get());
                    try {
                        IResourceStream resource = Application.get().getResourceSettings().getResourceStreamLocator().locate(((Object)((Object)this)).getClass(), "/" + Packages.absolutePath((Class)ref.getScope(), (String)"") + "/" + ref.getName());
                        if (resource != null) {
                            temp = Streams.readString((InputStream)resource.getInputStream());
                        }
                    }
                    catch (Exception e) {
                        temp = null;
                        e.printStackTrace();
                        LOGGER.error("error in merged processing", (Throwable)e);
                    }
                    if (compressor != null && temp != null) {
                        temp = compressor.compress(temp);
                    }
                    if (temp == null) continue;
                    buffer.append(temp).append("\r\n");
                }
                HashMap<String, StringBuffer> genJs = new HashMap<String, StringBuffer>();
                genJs.put("wiqueryresources", buffer);
                WiQueryMergedJavaScriptResourceReference.this.jstemplate.interpolate(genJs);
                return new StringResourceStream((CharSequence)WiQueryMergedJavaScriptResourceReference.this.jstemplate.asString(), WiQueryMergedJavaScriptResourceReference.CONTENT_TYPE);
            }
        };
    }
}

