/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.commons.merge;

import java.io.InputStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.time.Time;
import org.odlabs.wiquery.core.commons.merge.WiQueryHeaderResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiQueryMergedStyleSheetResourceReference
extends CompressedResourceReference
implements IClusterable {
    private static final long serialVersionUID = 6038498199511603297L;
    private static final String TEMPLATE_NAME = "wiquery-merged.css";
    private static final String CONTENT_TYPE = "text/css";
    private static final String REGEX = "url\\(.*?\\)";
    private static final Logger LOGGER = LoggerFactory.getLogger(WiQueryMergedStyleSheetResourceReference.class);
    private PackagedTextTemplate csstemplate;
    private WiQueryHeaderResponse wiQueryHeaderResponse;

    protected static String getCssUrl(String url, String baseUrl) {
        String cleaned = url.replace(" ", "").replace("'", "").replace("\"", "");
        cleaned = cleaned.substring(4);
        if ((cleaned = cleaned.substring(0, cleaned.length() - 1)).startsWith("http:") || cleaned.startsWith("https:") || cleaned.startsWith("ftp:") || cleaned.startsWith("file:")) {
            return "url(\"" + cleaned + "\")";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("url(\"");
        buffer.append(baseUrl);
        buffer.append(cleaned);
        buffer.append("\")");
        return buffer.toString();
    }

    public WiQueryMergedStyleSheetResourceReference(WiQueryHeaderResponse wiQueryHeaderResponse) {
        super(WiQueryMergedStyleSheetResourceReference.class, "wiquery-merged.css_" + WiQueryHeaderResponse.getMergedResourceName(wiQueryHeaderResponse.getStylesheet()));
        this.wiQueryHeaderResponse = wiQueryHeaderResponse;
        this.csstemplate = new PackagedTextTemplate(WiQueryMergedStyleSheetResourceReference.class, TEMPLATE_NAME);
    }

    public Time lastModifiedTime() {
        return this.csstemplate.lastModifiedTime();
    }

    protected Resource newResource() {
        return new Resource(){
            private static final long serialVersionUID = 1L;

            public IResourceStream getResourceStream() {
                return WiQueryMergedStyleSheetResourceReference.this.newResourceStream();
            }
        };
    }

    private IResourceStream newResourceStream() {
        String temp = null;
        StringBuffer buffer = new StringBuffer();
        HttpServletRequest request = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        String baseHost = request.getRequestURL().toString();
        baseHost = baseHost.substring(0, baseHost.indexOf(request.getRequestURI())) + request.getContextPath() + "/resources/";
        for (ResourceReference ref : this.wiQueryHeaderResponse.getStylesheet()) {
            ref.bind(Application.get());
            try {
                IResourceStream resource = Application.get().getResourceSettings().getResourceStreamLocator().locate(((Object)((Object)this)).getClass(), "/" + Packages.absolutePath((Class)ref.getScope(), (String)"") + "/" + ref.getName());
                if (resource != null) {
                    temp = Streams.readString((InputStream)resource.getInputStream());
                }
                String name = ref.getName();
                String cssUrl = baseHost + ref.getScope().getName() + "/" + (name.indexOf("/") < 0 ? "" : name.substring(0, name.lastIndexOf("/") + 1));
                Pattern p = Pattern.compile(REGEX);
                Matcher m = p.matcher(temp);
                int count = 0;
                while (m.find()) {
                    ++count;
                    String match = m.group();
                    String old = WiQueryMergedStyleSheetResourceReference.getCssUrl(match, cssUrl);
                    if (old.equals(match)) continue;
                    temp = temp.replace(match, old);
                }
            }
            catch (Exception e) {
                temp = null;
                e.printStackTrace();
                LOGGER.error("error in merged processing", (Throwable)e);
            }
            if (temp == null) continue;
            buffer.append(temp).append("\r\n");
        }
        HashMap<String, StringBuffer> genCss = new HashMap<String, StringBuffer>();
        genCss.put("wiqueryresources", buffer);
        this.csstemplate.interpolate(genCss);
        return new StringResourceStream((CharSequence)this.csstemplate.asString(), CONTENT_TYPE);
    }
}

