/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.javascript;

import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.odlabs.wiquery.core.commons.CoreJavaScriptResourceReference;
import org.odlabs.wiquery.core.commons.WiQuerySettings;
import org.odlabs.wiquery.core.commons.WiqueryGeneratedJavaScriptResource;
import org.odlabs.wiquery.core.javascript.JsScope;
import org.odlabs.wiquery.core.javascript.JsStatement;

public class JsQuery
implements Serializable,
IHeaderContributor {
    private static final long serialVersionUID = -5351600688981395614L;
    private Component component;
    private JsStatement statement;

    public JsQuery(Component component) {
        this.component = component;
        this.component.setOutputMarkupId(true);
    }

    public JsQuery() {
    }

    public JsStatement $() {
        this.statement = new JsStatement().$(this.component);
        return this.statement;
    }

    public JsStatement $(String selector) {
        this.statement = new JsStatement().$(this.component, selector);
        return this.statement;
    }

    public JsStatement document() {
        this.statement = new JsStatement().document();
        return this.statement;
    }

    public void renderHead(IHeaderResponse response) {
        IRequestTarget requestTarget;
        WiQuerySettings settings = WiQuerySettings.get();
        if (settings.isAutoImportJQueryResource()) {
            JavascriptResourceReference ref = settings.getJQueryCoreResourceReference();
            response.renderJavascriptReference((ResourceReference)(ref == null ? CoreJavaScriptResourceReference.get() : ref));
        }
        if ((requestTarget = (this.component != null ? this.component.getRequestCycle() : RequestCycle.get()).getRequestTarget()) == null || !(requestTarget instanceof AjaxRequestTarget)) {
            JsStatement onreadyStatement = new JsStatement();
            onreadyStatement.document().ready(JsScope.quickScope(this.statement.render()));
            response.renderString((CharSequence)("<script type=\"text/javascript\">" + onreadyStatement.render() + "</script>"));
        } else {
            this.addAjaxJavascript(requestTarget, this.statement.render().toString());
        }
    }

    public void contribute(Component component) {
        this.component = component;
        component.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)this)});
    }

    public JsStatement getStatement() {
        return this.statement;
    }

    public void setStatement(JsStatement jsStatement) {
        this.statement = jsStatement;
    }

    public void renderHead(IHeaderResponse response, IRequestTarget requestTarget) {
        String js;
        WiQuerySettings settings = WiQuerySettings.get();
        String string = js = this.statement == null ? null : this.statement.render().toString();
        if (js != null && js.trim().length() > 0) {
            JsStatement onreadyStatement = new JsStatement();
            onreadyStatement.document().ready(JsScope.quickScope(js));
            if (settings.isEmbedGeneratedStatements()) {
                if (settings.isAutoImportJQueryResource()) {
                    JavascriptResourceReference ref = settings.getJQueryCoreResourceReference();
                    response.renderJavascriptReference((ResourceReference)(ref == null ? CoreJavaScriptResourceReference.get() : ref));
                }
                if (requestTarget == null || !(requestTarget instanceof AjaxRequestTarget)) {
                    response.renderJavascript((CharSequence)WiqueryGeneratedJavaScriptResource.wiqueryGeneratedJavascriptCode(onreadyStatement.render()), "wiquery-gen-" + System.currentTimeMillis());
                } else {
                    this.addAjaxJavascript(requestTarget, js);
                }
            } else if (AjaxRequestTarget.get() == null) {
                response.renderJavascript((CharSequence)WiqueryGeneratedJavaScriptResource.wiqueryGeneratedJavascriptCode(onreadyStatement.render()), "wiquery-gen-" + System.currentTimeMillis());
            } else {
                this.addAjaxJavascript(requestTarget, js);
            }
        }
    }

    private void addAjaxJavascript(IRequestTarget requestTarget, final String js) {
        AjaxRequestTarget ajaxRequestTarget = (AjaxRequestTarget)requestTarget;
        ajaxRequestTarget.addListener(new AjaxRequestTarget.IListener(){

            public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget.IJavascriptResponse response) {
                response.addJavascript(js);
            }

            public void onBeforeRespond(Map<String, Component> map, AjaxRequestTarget target) {
            }
        });
    }
}

