/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.javascript;

import java.io.Serializable;
import org.odlabs.wiquery.core.javascript.JsScopeContext;
import org.odlabs.wiquery.core.javascript.JsStatement;

public abstract class JsScope
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StringBuilder statement;
    private JsScopeContext scopeContext;

    public static JsScope quickScope(final CharSequence javascriptCode) {
        return new JsScope(new String[0]){
            private static final long serialVersionUID = 1L;

            protected void execute(JsScopeContext scopeContext) {
                scopeContext.append(javascriptCode);
            }
        };
    }

    public static JsScope quickScope(final JsStatement jsStatement) {
        return new JsScope(new String[0]){
            private static final long serialVersionUID = 1L;

            protected void execute(JsScopeContext scopeContext) {
                scopeContext.append(jsStatement == null ? "" : jsStatement.render());
            }
        };
    }

    public JsScope(String ... scopeParameters) {
        this.scopeContext = new JsScopeContext(scopeParameters);
        this.statement = null;
    }

    protected abstract void execute(JsScopeContext var1);

    private JsScope closeScope() {
        this.statement.append("}");
        return this;
    }

    public CharSequence render() {
        if (this.statement == null) {
            this.statement = new StringBuilder();
            this.statement.append("function(");
            this.statement.append(this.scopeContext.scopeDeclaration());
            this.statement.append(") {\n");
            this.execute(this.scopeContext);
            this.statement.append(this.scopeContext.render());
            this.closeScope();
        }
        return this.statement.toString();
    }
}

