/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.javascript;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.odlabs.wiquery.core.events.EventLabel;

public class JsUtils {
    public static CharSequence array(CharSequence ... args) {
        StringBuffer array = new StringBuffer();
        array.append("[");
        if (args.length > 0) {
            array.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                array.append(", " + args[i]);
            }
        }
        array.append("]");
        return array;
    }

    public static String doubleQuotes(CharSequence stringToDoubleQuote) {
        return JsUtils.doubleQuotes(stringToDoubleQuote, false);
    }

    public static String doubleQuotes(CharSequence stringToDoubleQuote, boolean escapeDoubleQuote) {
        return "\"" + (escapeDoubleQuote ? JsUtils.escapeDoubleQuote(stringToDoubleQuote) : stringToDoubleQuote) + "\"";
    }

    public static String escapeDoubleQuote(CharSequence stringToDoubleQuote) {
        return stringToDoubleQuote == null ? null : stringToDoubleQuote.toString().replace("\"", "\\\"");
    }

    public static String escapeQuote(CharSequence stringToQuote) {
        return stringToQuote == null ? null : stringToQuote.toString().replace("'", "\\'");
    }

    public static String implode(EventLabel ... eventLabels) {
        if (eventLabels.length == 0) {
            return "''";
        }
        String output = "'" + eventLabels[0].getEventLabel();
        for (int i = 1; i < eventLabels.length; ++i) {
            EventLabel eventLabel = eventLabels[i];
            output = output + " " + eventLabel.getEventLabel();
        }
        return output + "'";
    }

    public static String json(Serializable jsonObject) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = new JsonFactory().createJsonGenerator((Writer)sw);
        new ObjectMapper().writeValue(gen, (Object)jsonObject);
        return sw.toString();
    }

    public static String quotes(CharSequence stringToQuote) {
        return JsUtils.quotes(stringToQuote, false);
    }

    public static String quotes(CharSequence stringToQuote, boolean escapeQuote) {
        return "'" + (escapeQuote ? JsUtils.escapeQuote(stringToQuote) : stringToQuote) + "'";
    }

    public static String string(int value) {
        return String.valueOf(value);
    }
}

