/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.jqueryplugins;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.util.string.Strings;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.javascript.JsUtils;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.datepicker.DateOption;

public class JQueryCookieOption
implements IComplexOption {
    private static final long serialVersionUID = 9153408474806895999L;
    private String value;
    private String name;
    private Options options;

    public JQueryCookieOption(String name) {
        if (Strings.isEmpty((CharSequence)name)) {
            throw new WicketRuntimeException("name cannot be null or empty");
        }
        this.options = new Options();
        this.setName(name);
    }

    public CharSequence getJavascriptOption() {
        return this.options.getJavaScriptOptions();
    }

    protected Options getOptions() {
        return this.options;
    }

    public JQueryCookieOption setDomain(String domain) {
        this.options.putLiteral("domain", domain);
        return this;
    }

    public String getDomain() {
        return this.options.getLiteral("domain");
    }

    public JQueryCookieOption setExpires(DateOption expires) {
        this.options.put("expires", expires);
        return this;
    }

    public DateOption getExpires() {
        IComplexOption expires = this.options.getComplexOption("expires");
        if (expires != null && expires instanceof DateOption) {
            return (DateOption)expires;
        }
        return null;
    }

    private JQueryCookieOption setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JQueryCookieOption setPath(String path) {
        this.options.putLiteral("path", path);
        return this;
    }

    public String getPath() {
        return this.options.getLiteral("path");
    }

    public JQueryCookieOption setSecure(boolean secure) {
        this.options.put("secure", secure);
        return this;
    }

    public boolean isSecure() {
        if (this.options.containsKey("secure")) {
            return this.options.getBoolean("secure");
        }
        return false;
    }

    public JQueryCookieOption setValue(String value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public JsStatement deleteCookie() {
        return new JsStatement().$().chain("cookie", JsUtils.quotes(this.getName()), "null", this.getJavascriptOption());
    }

    public void deleteCookie(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.deleteCookie().render().toString());
    }

    public JsStatement getCookie() {
        return new JsStatement().$().chain("cookie", JsUtils.quotes(this.getName()));
    }

    public JsStatement setCookie() {
        return new JsStatement().$().chain("cookie", JsUtils.quotes(this.getName()), JsUtils.quotes(this.getValue()), this.getJavascriptOption());
    }

    public void setCookie(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.setCookie().render().toString());
    }
}

