/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.core.options;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.odlabs.wiquery.core.javascript.JsScope;
import org.odlabs.wiquery.core.options.BooleanOption;
import org.odlabs.wiquery.core.options.DefaultOptionsRenderer;
import org.odlabs.wiquery.core.options.DoubleOption;
import org.odlabs.wiquery.core.options.FloatOption;
import org.odlabs.wiquery.core.options.ICollectionItemOptions;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.IModelOption;
import org.odlabs.wiquery.core.options.IOptionsRenderer;
import org.odlabs.wiquery.core.options.ITypedOption;
import org.odlabs.wiquery.core.options.IntegerOption;
import org.odlabs.wiquery.core.options.LiteralOption;
import org.odlabs.wiquery.core.options.LongOption;
import org.odlabs.wiquery.core.options.ShortOption;
import org.odlabs.wiquery.core.options.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
implements IModel<Options> {
    private static final long serialVersionUID = 1L;
    private Component owner;
    private Map<String, Object> options = new LinkedHashMap<String, Object>();
    private IOptionsRenderer optionsRenderer;

    public Options() {
        this(null);
    }

    public Options(Component owner) {
        this.owner = owner;
        this.optionsRenderer = DefaultOptionsRenderer.get();
    }

    public void setOwner(Component owner) {
        if (this.owner != null && this.owner != owner) {
            throw new IllegalArgumentException("Cannot use the same Options for multiple components");
        }
        this.owner = owner;
    }

    public boolean containsKey(Object key) {
        return this.options.containsKey(key);
    }

    public String get(String key) {
        String ret = (String)this.getValueFromOptions(key, StringOption.class);
        if (ret == null && this.options.containsKey(ret)) {
            ret = this.options.get(key).toString();
        }
        return ret;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.getValueFromOptions(key, BooleanOption.class);
    }

    public IComplexOption getComplexOption(String key) {
        Object object = this.options.get(key);
        if (object instanceof IComplexOption) {
            return (IComplexOption)object;
        }
        return null;
    }

    public Double getDouble(String key) {
        return (Double)this.getValueFromOptions(key, DoubleOption.class);
    }

    public Float getFloat(String key) {
        return (Float)this.getValueFromOptions(key, FloatOption.class);
    }

    public Integer getInt(String key) {
        return (Integer)this.getValueFromOptions(key, IntegerOption.class);
    }

    public CharSequence getJavaScriptOptions() {
        StringBuilder sb = new StringBuilder();
        this.optionsRenderer.renderBefore(sb);
        int count = 0;
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            boolean isLast;
            String key = entry.getKey();
            IModelOption value = entry.getValue();
            if (value instanceof IModelOption) {
                value = ((IModelOption)value).wrapOnAssignment(this.owner);
            }
            boolean bl = isLast = count >= this.options.size() - 1;
            if (value instanceof JsScope) {
                sb.append(this.optionsRenderer.renderOption(key, ((JsScope)((Object)value)).render(), isLast));
            } else if (value instanceof ICollectionItemOptions) {
                sb.append(this.optionsRenderer.renderOption(key, ((ICollectionItemOptions)((Object)value)).getJavascriptOption(), isLast));
            } else if (value instanceof IComplexOption) {
                sb.append(this.optionsRenderer.renderOption(key, ((IComplexOption)((Object)value)).getJavascriptOption(), isLast));
            } else if (value instanceof ITypedOption) {
                sb.append(this.optionsRenderer.renderOption(key, ((ITypedOption)((Object)value)).getJavascriptOption(), isLast));
            } else {
                sb.append(this.optionsRenderer.renderOption(key, value, isLast));
            }
            ++count;
        }
        this.optionsRenderer.renderAfter(sb);
        return sb;
    }

    public ICollectionItemOptions getListItemOptions(String key) {
        Object object = this.options.get(key);
        if (object instanceof ICollectionItemOptions) {
            return (ICollectionItemOptions)object;
        }
        return null;
    }

    public String getLiteral(String key) {
        return (String)this.getValueFromOptions(key, LiteralOption.class);
    }

    public Short getShort(String key) {
        return (Short)this.getValueFromOptions(key, ShortOption.class);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    private <T, O extends IModelOption<T>> T getValueFromOptions(String key, Class<O> optionClass) {
        Object object = this.options.get(key);
        if (optionClass.isInstance(object)) {
            IModelOption option = (IModelOption)optionClass.cast(object);
            return (T)option.wrapOnAssignment(this.owner).getValue();
        }
        return null;
    }

    private void putOption(String key, IModelOption<?> option) {
        this.options.put(key, option);
    }

    public Options put(String key, boolean value) {
        this.putOption(key, new BooleanOption(value));
        return this;
    }

    public Options putBoolean(String key, IModel<Boolean> value) {
        this.putOption(key, new BooleanOption(value));
        return this;
    }

    public Options put(String key, double value) {
        this.putOption(key, new DoubleOption(value));
        return this;
    }

    public Options putDouble(String key, IModel<Double> value) {
        this.putOption(key, new DoubleOption(value));
        return this;
    }

    public Options put(String key, float value) {
        this.putOption(key, new FloatOption(Float.valueOf(value)));
        return this;
    }

    public Options putFloat(String key, IModel<Float> value) {
        this.putOption(key, new FloatOption(value));
        return this;
    }

    public Options put(String key, ICollectionItemOptions value) {
        this.options.put(key, value);
        return this;
    }

    public Options put(String key, IComplexOption value) {
        this.options.put(key, value);
        return this;
    }

    public Options put(String key, int value) {
        this.putOption(key, new IntegerOption(value));
        return this;
    }

    public Options putInteger(String key, IModel<Integer> value) {
        this.putOption(key, new IntegerOption(value));
        return this;
    }

    public Options put(String key, JsScope value) {
        this.options.put(key, value);
        return this;
    }

    public Options put(String key, short value) {
        this.putOption(key, new ShortOption(value));
        return this;
    }

    public Options putShort(String key, IModel<Short> value) {
        this.putOption(key, new ShortOption(value));
        return this;
    }

    public Options put(String key, String value) {
        this.putOption(key, new StringOption(value));
        return this;
    }

    public Options putString(String key, IModel<String> value) {
        this.putOption(key, new StringOption(value));
        return this;
    }

    public Options put(String key, long value) {
        this.putOption(key, new LongOption(value));
        return this;
    }

    public Options putLong(String key, IModel<Long> value) {
        this.putOption(key, new LongOption(value));
        return this;
    }

    public Options putLiteral(String key, String value) {
        this.putOption(key, new LiteralOption(value));
        return this;
    }

    public Options putLiteral(String key, IModel<String> value) {
        this.putOption(key, new LiteralOption(value));
        return this;
    }

    public void removeOption(String key) {
        this.options.remove(key);
    }

    public void setRenderer(IOptionsRenderer optionsRenderer) {
        this.optionsRenderer = optionsRenderer;
    }

    public Options getObject() {
        return this;
    }

    public void setObject(Options object) {
        throw new UnsupportedOperationException("The setObject() function is not supported for object Options.");
    }

    public void detach() {
        this.onDetach(this.options);
    }

    private void onDetach(Object detachable) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(detachable instanceof Component)) break block2;
                        ((Component)detachable).detach();
                        break block3;
                    }
                    if (!(detachable instanceof IDetachable)) break block4;
                    ((IDetachable)detachable).detach();
                    break block3;
                }
                if (!(detachable instanceof Map)) break block5;
                for (Map.Entry entry : ((Map)detachable).entrySet()) {
                    this.onDetach(entry.getKey());
                    this.onDetach(entry.getValue());
                }
                break block3;
            }
            if (!(detachable instanceof Iterable)) break block3;
            Iterator iter = ((Iterable)detachable).iterator();
            while (iter.hasNext()) {
                this.onDetach(iter.next());
            }
        }
    }
}

