/*
 * Decompiled with CFR 0.152.
 */
package org.odlabs.wiquery.ui.accordion;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.odlabs.wiquery.core.commons.IWiQueryPlugin;
import org.odlabs.wiquery.core.commons.WiQueryResourceManager;
import org.odlabs.wiquery.core.javascript.JsQuery;
import org.odlabs.wiquery.core.javascript.JsScope;
import org.odlabs.wiquery.core.javascript.JsStatement;
import org.odlabs.wiquery.core.options.IComplexOption;
import org.odlabs.wiquery.core.options.LiteralOption;
import org.odlabs.wiquery.core.options.Options;
import org.odlabs.wiquery.ui.accordion.AccordionActive;
import org.odlabs.wiquery.ui.accordion.AccordionAnimated;
import org.odlabs.wiquery.ui.accordion.AccordionHeader;
import org.odlabs.wiquery.ui.accordion.AccordionIcon;
import org.odlabs.wiquery.ui.accordion.AccordionJavaScriptResourceReference;
import org.odlabs.wiquery.ui.commons.WiQueryUIPlugin;
import org.odlabs.wiquery.ui.core.JsScopeUiEvent;
import org.odlabs.wiquery.ui.themes.UiIcon;
import org.odlabs.wiquery.ui.widget.WidgetJavascriptResourceReference;

@WiQueryUIPlugin
public class Accordion
extends WebMarkupContainer
implements IWiQueryPlugin {
    private static final long serialVersionUID = 2L;
    private Options options = new Options((Component)this);

    public Accordion(String id) {
        super(id);
    }

    protected void detachModel() {
        super.detachModel();
        this.options.detach();
    }

    public void contribute(WiQueryResourceManager wiQueryResourceManager) {
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)WidgetJavascriptResourceReference.get());
        wiQueryResourceManager.addJavaScriptResource((ResourceReference)AccordionJavaScriptResourceReference.get());
    }

    public JsStatement statement() {
        return new JsQuery((Component)this).$().chain("accordion", this.options.getJavaScriptOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    public Accordion setAnimated(AccordionAnimated animationEffect) {
        this.options.put("animated", animationEffect);
        return this;
    }

    public AccordionAnimated getAnimated() {
        IComplexOption animated = this.options.getComplexOption("animated");
        if (animated != null && animated instanceof AccordionAnimated) {
            return (AccordionAnimated)animated;
        }
        return new AccordionAnimated("slide");
    }

    @Deprecated
    public Accordion setAnimationEffect(AccordionAnimated animationEffect) {
        this.options.put("animated", animationEffect);
        return this;
    }

    @Deprecated
    public AccordionAnimated getAnimationEffect() {
        IComplexOption animated = this.options.getComplexOption("animated");
        if (animated != null && animated instanceof AccordionAnimated) {
            return (AccordionAnimated)animated;
        }
        return new AccordionAnimated("slide");
    }

    public Accordion setAutoHeight(boolean autoHeight) {
        this.options.put("autoHeight", autoHeight);
        return this;
    }

    public boolean isAutoHeight() {
        if (this.options.containsKey("autoHeight")) {
            return this.options.getBoolean("autoHeight");
        }
        return true;
    }

    @Deprecated
    public Accordion setTriggerEvent(AccordionTriggerEvent accordionTriggerEvent) {
        return this.setEvent(accordionTriggerEvent);
    }

    @Deprecated
    public AccordionTriggerEvent getTriggerEvent() {
        return this.getEvent();
    }

    public Accordion setEvent(AccordionTriggerEvent accordionTriggerEvent) {
        this.options.putLiteral("event", accordionTriggerEvent.name().toLowerCase());
        return this;
    }

    public AccordionTriggerEvent getEvent() {
        String literal = this.options.getLiteral("event");
        return literal == null ? AccordionTriggerEvent.CLICK : AccordionTriggerEvent.valueOf(literal.toUpperCase());
    }

    public Accordion setFillSpace(boolean fillSpace) {
        this.options.put("fillSpace", fillSpace);
        return this;
    }

    public boolean isFillSpace() {
        if (this.options.containsKey("fillSpace")) {
            return this.options.getBoolean("fillSpace");
        }
        return false;
    }

    public Accordion setDisabled(boolean disabled) {
        this.options.put("disabled", disabled);
        return this;
    }

    public boolean isDisabled() {
        if (this.options.containsKey("disabled")) {
            return this.options.getBoolean("disabled");
        }
        return false;
    }

    public Accordion setHeader(AccordionHeader header) {
        this.options.put("header", header);
        return this;
    }

    public AccordionHeader getHeader() {
        IComplexOption header = this.options.getComplexOption("header");
        if (header != null && header instanceof AccordionHeader) {
            return (AccordionHeader)header;
        }
        return new AccordionHeader(new LiteralOption("> li> :first-child, > :not(li):even"));
    }

    public Accordion setClearStyle(boolean clearStyle) {
        this.options.put("clearStyle", clearStyle);
        return this;
    }

    public boolean isClearStyle() {
        if (this.options.containsKey("clearStyle")) {
            return this.options.getBoolean("clearStyle");
        }
        return false;
    }

    public Accordion setCollapsible(boolean collapsible) {
        this.options.put("collapsible", collapsible);
        return this;
    }

    public boolean isCollapsible() {
        if (this.options.containsKey("collapsible")) {
            return this.options.getBoolean("collapsible");
        }
        return false;
    }

    public Accordion setNavigation(boolean navigation) {
        this.options.put("navigation", navigation);
        return this;
    }

    public boolean isNavigation() {
        if (this.options.containsKey("navigation")) {
            return this.options.getBoolean("navigation");
        }
        return false;
    }

    public Accordion setNavigationFilter(JsScope navigationFilter) {
        this.options.put("navigationFilter", navigationFilter);
        return this;
    }

    public AccordionIcon getIcons() {
        IComplexOption icons = this.options.getComplexOption("icons");
        if (icons != null && icons instanceof AccordionIcon) {
            return (AccordionIcon)icons;
        }
        return new AccordionIcon("ui-icon-triangle-1-e", "ui-icon-triangle-1-s");
    }

    public Accordion setIcons(AccordionIcon icons) {
        if (icons != null) {
            this.options.put("icons", icons);
        } else {
            this.options.removeOption("icons");
        }
        return this;
    }

    public Accordion setIcons(UiIcon header, UiIcon headerSelected) {
        this.setIcons(new AccordionIcon(header, headerSelected));
        return this;
    }

    public Accordion hideIcons() {
        this.setIcons(new AccordionIcon(false));
        return this;
    }

    public AccordionActive getActive() {
        IComplexOption active = this.options.getComplexOption("active");
        if (active != null && active instanceof AccordionActive) {
            return (AccordionActive)active;
        }
        return null;
    }

    public Accordion setActive(AccordionActive active) {
        this.options.put("active", active);
        return this;
    }

    public Accordion setChangeEvent(JsScopeUiEvent change) {
        this.options.put("change", change);
        return this;
    }

    public Accordion setChangeStartEvent(JsScopeUiEvent changestart) {
        this.options.put("changestart", changestart);
        return this;
    }

    public JsStatement activate(int index) {
        return new JsQuery((Component)this).$().chain("accordion", "'activate'", Integer.toString(index));
    }

    public void activate(AjaxRequestTarget ajaxRequestTarget, int index) {
        ajaxRequestTarget.appendJavascript(this.activate(index).render().toString());
    }

    public JsStatement destroy() {
        return new JsQuery((Component)this).$().chain("accordion", "'destroy'");
    }

    public void destroy(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.destroy().render().toString());
    }

    public JsStatement disable() {
        return new JsQuery((Component)this).$().chain("accordion", "'disable'");
    }

    public void disable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.disable().render().toString());
    }

    public JsStatement enable() {
        return new JsQuery((Component)this).$().chain("accordion", "'enable'");
    }

    public void enable(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.enable().render().toString());
    }

    public JsStatement widget() {
        return new JsQuery((Component)this).$().chain("accordion", "'widget'");
    }

    public void widget(AjaxRequestTarget ajaxRequestTarget) {
        ajaxRequestTarget.appendJavascript(this.widget().render().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccordionTriggerEvent {
        CLICK,
        MOUSEOVER;

    }
}

